/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.report;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.logback.report.IReportStore;
import kd.bos.logging.logback.report.store.EmptyReportStore;
import kd.bos.logging.logback.report.store.ProxyReportStore;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportStoreFactory {
    private static Logger logger = LoggerFactory.getLogger(ReportStoreFactory.class);
    private static String EXCEPTION_STORES = "audit.exception.report.stores";
    private static List<IReportStore> stores = new ArrayList<IReportStore>(4);
    private static IReportStore store = null;

    private static void loadStores(String configfilters) {
        String[] mfilters;
        for (String en : mfilters = configfilters.split(",")) {
            try {
                Class<?> cls = Class.forName(en);
                IReportStore me = (IReportStore)cls.newInstance();
                stores.add(me);
            }
            catch (Exception e) {
                logger.error("loadStores exception", (Throwable)e);
            }
        }
    }

    public static IReportStore getStore() {
        return store;
    }

    static {
        try {
            String configfilters = System.getProperty(EXCEPTION_STORES);
            if (StringUtils.isEmpty((String)configfilters)) {
                stores.add(new EmptyReportStore());
            } else {
                ReportStoreFactory.loadStores(configfilters);
            }
            store = new ProxyReportStore(stores);
        }
        catch (Exception t) {
            logger.error("init exception", (Throwable)t);
        }
    }
}

