/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.report.filter;

import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.logback.report.IReportFilter;
import kd.bos.logging.logback.report.ReportObject;

public class PatternLogFilter
implements IReportFilter {
    private static String level = null;
    private static String className = null;
    private static String methodName = null;
    private static String message = null;
    private static Map<String, String> logtags = new HashMap<String, String>();

    @Override
    public boolean match(ReportObject log) {
        if (log.getClassName().startsWith("kd.bos.util")) {
            return false;
        }
        boolean match = false;
        if (level == null) {
            return false;
        }
        if ("*".equals(level) || level.equalsIgnoreCase(log.getLevel())) {
            match = true;
        }
        if (match) {
            match = false;
            if (className == null) {
                return false;
            }
            if ("*".equals(className) || className.equalsIgnoreCase(log.getClassName())) {
                match = true;
            } else {
                int pos = className.indexOf("*");
                if (pos > 1 && log.getClassName().startsWith(className.substring(0, pos))) {
                    match = true;
                }
            }
        }
        if (match) {
            match = false;
            if (methodName == null) {
                return false;
            }
            if ("*".equals(methodName) || methodName.equalsIgnoreCase(log.getMethodName())) {
                match = true;
            }
        }
        if (match) {
            match = false;
            if (message == null) {
                return false;
            }
            if ("*".equals(message) || log.getMessage() != null && log.getMessage().indexOf(message) >= 0) {
                match = true;
            }
        }
        if (match) {
            match = false;
            if (logtags.isEmpty()) {
                return true;
            }
            Map<String, String> tags = log.getLogtags();
            if (tags == null || tags.isEmpty()) {
                return false;
            }
        }
        return match;
    }

    static {
        level = System.getProperty("audit.exception.report.PatternLogFilter.level");
        className = System.getProperty("audit.exception.report.PatternLogFilter.className");
        methodName = System.getProperty("audit.exception.report.PatternLogFilter.methodName");
        message = System.getProperty("audit.exception.report.PatternLogFilter.message");
        String tags = System.getProperty("audit.exception.report.PatternLogFilter.logtags");
        if (tags != null) {
            String[] tagarray;
            for (String tag : tagarray = tags.split(",")) {
                int pos = tag.indexOf(":");
                if (tag.length() <= 1 || pos <= 0) continue;
                String key = tag.substring(0, pos);
                String value = tag.substring(pos + 1);
                logtags.put(key, value);
            }
        }
    }
}

