/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.report.store;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.logback.report.IReportStore;
import kd.bos.logging.logback.report.ReportObject;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpApiStore
implements IReportStore {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiStore.class);
    private AtomicReference<String> token = new AtomicReference();
    private static String TOKEN_URL_NAME = "exception.report.tokenurl";
    private static String tokenUrl = null;
    private static String API_URL_NAME = "exception.report.apirul";
    private static String apiUrl = null;
    private static boolean ready = false;
    private static String appId = null;
    private static String secret = null;
    private static String tenantid = null;
    private static String accountId = null;
    private static String user = null;
    private static String password = null;

    @Override
    public void store(ReportObject log) {
        if (ready) {
            String newtoken;
            if (this.token.get() == null && (newtoken = this.getAccessToken(log)) != null) {
                this.token.set(newtoken);
            }
            if (this.token.get() == null) {
                return;
            }
            this.send(log);
        }
    }

    private void send(ReportObject log) {
        try {
            String formid = log.getFormid();
            String newapiurl = apiUrl.replaceAll("\\{formid\\}", formid);
            String result = HttpClientUtils.postjson((String)(newapiurl + this.token.get()), null, (String)log.toJson());
            if (result != null && (result.indexOf(Resources.getString((String)"\u672a\u7ecf\u6388\u6743", (String)"HttpApiStore_0", (String)"bos-audit-exception-report", (Object[])new Object[0])) >= 0 || result.indexOf("\"success\":false") >= 0)) {
                String newtoken = this.getAccessToken(log);
                if (newtoken != null) {
                    this.token.set(newtoken);
                }
                result = HttpClientUtils.postjson((String)(newapiurl + this.token.get()), null, (String)log.toJson());
            }
        }
        catch (Exception e) {
            logger.warn("httpclient send exception", (Throwable)e);
        }
    }

    private static boolean check() {
        return !(!StringUtils.isNotEmpty((String)tokenUrl) || !StringUtils.isNotEmpty((String)apiUrl) || !tokenUrl.startsWith("http://") && !tokenUrl.startsWith("https://") || !apiUrl.startsWith("http://") && !apiUrl.startsWith("https://"));
    }

    private String getAccessToken(ReportObject log) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("user", user);
            map.put("password", password);
            map.put("tenantid", tenantid);
            map.put("logintype", "2");
            String data = HttpClientUtils.postjson((String)tokenUrl, null, (String)JSONUtils.toString(map));
            if (data == null || "".equals(data)) {
                return null;
            }
            Map datamap = (Map)JSONUtils.cast((String)data, Map.class);
            Map infomap = (Map)datamap.get("data");
            if (infomap == null) {
                return null;
            }
            return (String)infomap.get("access_token");
        }
        catch (Exception e) {
            logger.warn("get access token exception", (Throwable)e);
            return null;
        }
    }

    private String getAppToken(ReportObject log) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("appId", appId);
            map.put("appSecuret", secret);
            map.put("tenantid", tenantid);
            map.put("accountId", accountId);
            String data = HttpClientUtils.postjson((String)tokenUrl, null, (String)JSONUtils.toString(map));
            if (data == null || "".equals(data)) {
                return null;
            }
            Map datamap = (Map)JSONUtils.cast((String)data, Map.class);
            Map infomap = (Map)datamap.get("data");
            if (infomap == null) {
                return null;
            }
            return (String)infomap.get("app_token");
        }
        catch (Exception e) {
            logger.warn("get app token exception", (Throwable)e);
            return null;
        }
    }

    static {
        tokenUrl = System.getProperty(TOKEN_URL_NAME);
        apiUrl = System.getProperty(API_URL_NAME);
        appId = System.getProperty("audit.exception.report.appId");
        secret = System.getProperty("audit.exception.report.secret");
        tenantid = System.getProperty("audit.exception.report.tenantid");
        accountId = System.getProperty("audit.exception.report.accountId");
        user = System.getProperty("audit.exception.report.user");
        password = System.getProperty("audit.exception.report.password");
        if (password != null) {
            password = Encrypters.decode((String)password);
        }
        ready = HttpApiStore.check();
    }
}

