/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.OperationContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ExceptionLogger {
    private static Map<String, Log> logs = new ConcurrentHashMap<String, Log>();

    private static Log getLog(Class<?> cla) {
        return logs.computeIfAbsent(cla.getName(), k -> LogFactory.getLog((String)k));
    }

    public static void log(Class<?> cla, String message, Throwable t) {
        ExceptionLogger.error(cla, message, t);
    }

    public static void error(Class<?> cla, String message, Throwable t) {
        OperationContextCreator.getOrCreateDefault((String)"dts");
        ExceptionLogger.getLog(cla).error(message, t);
    }

    public static void log(Class<?> cla, String message) {
        OperationContextCreator.getOrCreateDefault((String)"dts");
        ExceptionLogger.getLog(cla).warn(message);
    }

    public static void log(Class<?> cla, String message, Object ... objects) {
        OperationContextCreator.getOrCreateDefault((String)"dts");
        ExceptionLogger.getLog(cla).warn(message, objects);
    }

    public static String getStack(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return t.getMessage() + "," + sw.toString();
    }

    public static String getFullStack(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return t.getMessage() + "," + sw.toString();
    }
}

