/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.log.reporter;

import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.log.DtsStatusReporter;
import kd.bos.dts.log.DtsStatusType;

public class DtsStatusDbReporter
implements DtsStatusReporter {
    private static final String INSERT_SQL = "INSERT into T_DTS_LOG(FID,fsyncobject,Ftitle,fsynclog,flogtime) values(?,?,?,?,?);";

    @Override
    public void realtimeReport(long gid, DestinationRuleConfig config, String optype, int count, DtsStatusType statsType, long delayMs) {
        if (statsType == DtsStatusType.DATA_SYNCED) {
            this.writeRecord(config, optype, "count: " + count + " [delay " + delayMs + "ms]");
        }
    }

    @Override
    public void realtimeExceptionReport(Exception e, long gid, DestinationRuleConfig config, String optype, int count, DtsStatusType statsType, long delayMs) {
        this.writeRecord(config, optype, ExceptionLogger.getStack(e));
    }

    @Override
    public void confInitFoundReport(List<String> configList, DtsStatusType configChangedFound) {
        this.writeRecord("confInitFoundReport", configChangedFound.getName(), configList.toString());
    }

    @Override
    public void confInitReport(String optype, DtsStatusType statsType) {
        this.writeRecord("confInitReport", optype, statsType.getName());
    }

    @Override
    public void confInitReport(DestinationRuleConfig config, String optype, DtsStatusType statsType) {
        this.writeRecord(config, optype, statsType.getName());
    }

    @Override
    public void confInitCountReport(DestinationRuleConfig config, String optype, DtsStatusType dtsStatusType, int total, String filterdesc) {
        this.writeRecord(config, optype, "count: " + total + " [" + (Object)((Object)dtsStatusType) + filterdesc + "]");
    }

    @Override
    public void confInitReportError(Exception e, DestinationRuleConfig config) {
        this.writeRecord(config, "confInitReportError", ExceptionLogger.getStack(e));
    }

    @Override
    public void confInitCountReportError(Exception e, DestinationRuleConfig config, int count, String desc) {
        this.writeRecord(config, "confInitCountReportError", "count: " + count + " [" + desc + "]" + ExceptionLogger.getStack(e));
    }

    private void writeRecord(DestinationRuleConfig syncobj, String type, String desc) {
        this.writeRecord(syncobj.getShowName(), type, desc);
    }

    private void writeRecord(String syncobj, String type, String desc) {
        if (desc.length() > 500) {
            desc = desc.substring(0, 490);
        }
        if (type.length() > 100) {
            type = type.substring(0, 99);
        }
        long id = DB.genGlobalLongId();
        try (TXHandle h = TX.requiresNew((String)"bos_dts_Oplog");){
            DB.execute((DBRoute)DBRoute.basedata, (String)INSERT_SQL, (Object[])new Object[]{id, syncobj, type, desc, new Date()});
        }
    }
}

