/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.log.reporter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.log.DateUtil;
import kd.bos.dts.log.DtsStatusReporter;
import kd.bos.dts.log.DtsStatusType;
import kd.bos.dts.log.StoreageHelper;
import kd.bos.dts.storage.es.ESBatchStorage;
import kd.bos.id.IDService;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.util.async.AsyncOutput;
import org.elasticsearch.action.bulk.BulkItemResponse;

public class DtsStatusESReporter
implements DtsStatusReporter {
    private AsyncOutput<Map<String, Object>> output = AsyncOutput.create((String)"DtsStatusESReporter-async", (int)2, data -> this.reportData((List<Map<String, Object>>)data));

    public DtsStatusESReporter() {
        this.output.withMaxTotalQueueCount(10000);
    }

    @Override
    public void realtimeReport(long gid, DestinationRuleConfig config, String optype, int count, DtsStatusType statsType, long delayMs) {
        HashMap<String, Object> m = new HashMap<String, Object>(8);
        m.put("dts_gid", gid);
        this.filledDestinationConfig(config, m);
        this.filledStap(m);
        m.put("dts_count", count);
        m.put("dts_delay", delayMs);
        m.put("dts_optype", optype);
        m.put("dts_status", statsType.getName());
        m.put("dts_logtype", "online");
        try {
            this.store(m);
        }
        catch (Exception e) {
            ExceptionLogger.error(DtsStatusESReporter.class, "DstStatusESReporter realtimeReport", e);
        }
    }

    private void store(Map<String, Object> m) {
        this.output.onEvent(m);
    }

    private Object reportData(List<Map<String, Object>> data) {
        try (ESBatchStorage storage = ESBatchStorage.create(StoreageHelper.getRestClient());){
            data.forEach(m -> storage.addUpsertBatch("doc", StoreageHelper.indexName, String.valueOf(IDService.get().genLongId()), (Map<?, ?>)m));
            BulkItemResponse response = storage.executeBatch(null);
            if (response != null && response.isFailed()) {
                ExceptionLogger.log(DtsStatusESReporter.class, "DstStatusESReporter reportData error:" + response.getFailureMessage());
            }
        }
        return null;
    }

    @Override
    public void realtimeExceptionReport(Exception e, long gid, DestinationRuleConfig config, String optype, int count, DtsStatusType statsType, long delayMs) {
        HashMap<String, Object> m = new HashMap<String, Object>(8);
        m.put("dts_gid", gid);
        this.filledDestinationConfig(config, m);
        this.filledStap(m);
        m.put("dts_count", count);
        m.put("dts_delay", delayMs);
        m.put("dts_optype", optype);
        m.put("dts_status", statsType.getName());
        m.put("dts_exception", ExceptionLogger.getFullStack(e));
        m.put("dts_logtype", "exception");
        this.store(m);
    }

    @Override
    public void confInitFoundReport(List<String> configList, DtsStatusType statsType) {
        HashMap<String, Object> m = new HashMap<String, Object>(4);
        this.filledStap(m);
        m.put("dts_status", statsType.getName());
        m.put("found_configlist", configList.toString());
        m.put("dts_logtype", "initconfig");
        this.store(m);
    }

    @Override
    public void confInitReport(String optype, DtsStatusType statsType) {
        HashMap<String, Object> m = new HashMap<String, Object>(4);
        this.filledStap(m);
        m.put("dts_status", statsType.getName());
        m.put("dts_optype", optype);
        m.put("dts_logtype", "initconfig");
        try {
            this.store(m);
        }
        catch (Exception e) {
            ExceptionLogger.error(DtsStatusESReporter.class, "confInitReport error", e);
        }
    }

    @Override
    public void confInitReport(DestinationRuleConfig config, String optype, DtsStatusType statsType) {
        HashMap<String, Object> m = new HashMap<String, Object>(4);
        this.filledDestinationConfig(config, m);
        this.filledStap(m);
        m.put("dts_status", statsType.getName());
        m.put("dts_optype", optype);
        m.put("dts_logtype", "initconfig");
        this.store(m);
    }

    @Override
    public void confInitCountReport(DestinationRuleConfig config, String optype, DtsStatusType statsType, int total, String filterdesc) {
        HashMap<String, Object> m = new HashMap<String, Object>(4);
        this.filledDestinationConfig(config, m);
        this.filledStap(m);
        m.put("dts_status", statsType.getName());
        m.put("dts_optype", optype);
        m.put("dts_count", total);
        m.put("dts_description", filterdesc);
        m.put("dts_logtype", "initconfig");
        this.store(m);
    }

    @Override
    public void confInitReportError(Exception e, DestinationRuleConfig config) {
        HashMap<String, Object> m = new HashMap<String, Object>(4);
        this.filledDestinationConfig(config, m);
        this.filledStap(m);
        m.put("dts_status", DtsStatusType.CONFIG_INIT_EXCEPTION.getName());
        m.put("dts_exception", ExceptionLogger.getFullStack(e));
        m.put("dts_logtype", "exception_init");
        this.store(m);
    }

    @Override
    public void confInitCountReportError(Exception e, DestinationRuleConfig config, int count, String desc) {
        HashMap<String, Object> m = new HashMap<String, Object>(8);
        this.filledDestinationConfig(config, m);
        this.filledStap(m);
        m.put("dts_exception", ExceptionLogger.getFullStack(e));
        m.put("dts_count", count);
        m.put("dts_description", desc);
        m.put("dts_logtype", "exception_init");
        this.store(m);
    }

    private String getAccountId() {
        return RequestContext.get().getAccountId();
    }

    private void filledStap(Map<String, Object> m) {
        m.put("dts_timestap", DateUtil.addHours(new Date(), 8));
        m.put("dts_account", this.getAccountId());
    }

    private void filledDestinationConfig(DestinationRuleConfig config, Map<String, Object> m) {
        m.put("entity_number", config.getEntityNumber());
        DestinationTransRule rule = config.getRule();
        m.put("destination_type", rule.getType().getName());
        m.put("region", rule.getRegion());
        m.put("businesstype", rule.getBusinessType());
    }
}

