/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.storage.es;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.log.DateUtil;
import kd.bos.dts.log.query.PageInfo;
import kd.bos.dts.storage.es.ESQuery;
import kd.bos.dts.storage.es.HighLevelFilterBuilder;
import kd.bos.exception.KDException;
import kd.bos.nosql.operate.Query;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class ESQueryImpl
implements ESQuery {
    private RestHighLevelClient client;
    private final String index;
    private final String type;
    public static final String SPLIT = "..";
    private static final String CONDITIONPRE = "select * from dual ";
    private int version;

    protected ESQueryImpl(RestHighLevelClient client, String index, String type) {
        this.client = client;
        this.index = index;
        this.type = type;
        try {
            MainResponse info = client.info(RequestOptions.DEFAULT);
            this.version = info.getVersion().major;
        }
        catch (IOException e) {
            this.version = 6;
        }
    }

    @Override
    public PageInfo<Map<String, String>> searchConditionPage(String[] selectfields, String whereCondition, Date fromDate, Date toDate, int fromIndex, int size) {
        SearchRequest req = new SearchRequest(new String[]{this.index});
        if (this.version <= 6) {
            req.types(new String[]{this.type});
        }
        req.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = null;
        if (fromDate != null && toDate != null) {
            boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"dts_timestap").gte((Object)DateUtil.addHours(fromDate, 8).getTime()).lte((Object)DateUtil.addHours(toDate, 8).getTime()));
        }
        if (whereCondition != null && whereCondition.length() > 0) {
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
            }
            StringBuilder oql = new StringBuilder(CONDITIONPRE);
            if (whereCondition.trim().toLowerCase(Locale.ENGLISH).startsWith("where")) {
                oql.append(" ").append(whereCondition);
            } else {
                oql.append(" where ").append(whereCondition);
            }
            QueryBuilder qb = (QueryBuilder)Query.fromOQL((String)oql.toString()).getFilter().build(HighLevelFilterBuilder.getInstance());
            boolQueryBuilder.must(qb);
        }
        SortBuilder sortBuilder = SortBuilders.fieldSort((String)"dts_timestap").order(SortOrder.DESC);
        sourceBuilder.sort(sortBuilder);
        if (boolQueryBuilder == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery()).from(fromIndex).size(size);
        } else {
            sourceBuilder.query((QueryBuilder)boolQueryBuilder).from(fromIndex).size(size);
        }
        req.source(sourceBuilder);
        try {
            SearchResponse res = this.client.search(req, RequestOptions.DEFAULT);
            SearchHit[] hits = res.getHits().getHits();
            ArrayList result = new ArrayList(4);
            for (SearchHit hit : hits) {
                Map source = hit.getSourceAsMap();
                HashMap<String, String> row = new HashMap<String, String>(4);
                for (String field : selectfields) {
                    Object v = source.get(field);
                    if (v == null) continue;
                    row.put(field, v.toString());
                }
                result.add(row);
            }
            PageInfo<Map<String, String>> pageInfo = new PageInfo<Map<String, String>>(result);
            pageInfo.setTotal(res.getHits().getTotalHits());
            pageInfo.setPage(fromIndex);
            pageInfo.setSize(size);
            return pageInfo;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, DtsErrorCode.ioError, new Object[]{"ESQuery.query error"});
        }
    }

    @Override
    public List<Map<String, String>> searchCondition(String[] selectfields, String whereCondition, int fromIndex, int size) {
        return this.searchCondition(selectfields, null, null, null, whereCondition, fromIndex, size);
    }

    @Override
    public List<Map<String, String>> searchCondition(String[] selectfields, Date fromDate, Date toDate, int fromIndex, int size) {
        return this.searchCondition(selectfields, fromDate, toDate, null, fromIndex, size);
    }

    @Override
    public List<Map<String, String>> searchCondition(String[] selectfields, Date fromDate, Date toDate, String whereCondition, int fromIndex, int size) {
        return this.searchCondition(selectfields, "dts_timestap", fromDate, toDate, whereCondition, fromIndex, size);
    }

    @Override
    public List<Map<String, String>> searchCondition(String[] selectfields, String dateFiled, Date fromDate, Date toDate, String whereCondition, int fromIndex, int size) {
        return this.searchCondition(selectfields, dateFiled, fromDate, toDate, whereCondition, fromIndex, size, null, null);
    }

    @Override
    public Map<String, Long> searchAgg(String[] aggName, String aggField, Date from, Date to, String whereCondition) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        if (this.version <= 6) {
            searchRequest.types(new String[]{this.type});
        }
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (from != null && to != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"dts_timestap").gte((Object)DateUtil.addHours(from, 8).getTime()).lte((Object)DateUtil.addHours(to, 8).getTime()));
        }
        if (whereCondition != null && whereCondition.length() > 0) {
            StringBuilder oql = new StringBuilder(CONDITIONPRE);
            if (whereCondition.trim().toLowerCase(Locale.ENGLISH).startsWith("where")) {
                oql.append(" ").append(whereCondition);
            } else {
                oql.append(" where ").append(whereCondition);
            }
            QueryBuilder qb = (QueryBuilder)Query.fromOQL((String)oql.toString()).getFilter().build(HighLevelFilterBuilder.getInstance());
            boolQueryBuilder.must(qb);
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(0);
        if (aggName.length == 1) {
            return this.searchGroupString(sourceBuilder, searchRequest, aggName[0], aggField);
        }
        return this.searchGroupStringMulit(sourceBuilder, searchRequest, aggName, aggField);
    }

    @Override
    public double searchAvg(String[] aggNames, String avgField, Date from, Date to, String whereCondition) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        if (this.version <= 6) {
            searchRequest.types(new String[]{this.type});
        }
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"dts_timestap").gte((Object)from.getTime()).lte((Object)to.getTime()));
        if (whereCondition != null && whereCondition.length() > 0) {
            StringBuilder oql = new StringBuilder(CONDITIONPRE);
            if (whereCondition.trim().toLowerCase(Locale.ENGLISH).startsWith("where")) {
                oql.append(" ").append(whereCondition);
            } else {
                oql.append(" where ").append(whereCondition);
            }
            QueryBuilder qb = (QueryBuilder)Query.fromOQL((String)oql.toString()).getFilter().build(HighLevelFilterBuilder.getInstance());
            boolQueryBuilder.must(qb);
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        ValuesSourceAggregationBuilder avgb = AggregationBuilders.avg((String)avgField).field(avgField);
        sourceBuilder.aggregation((AggregationBuilder)avgb);
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Avg avg = (Avg)response.getAggregations().get(avgField);
            Double value = avg.getValue();
            if (value.isInfinite()) {
                return 0.0;
            }
            BigDecimal bg = BigDecimal.valueOf(value).setScale(2, RoundingMode.HALF_UP);
            return bg.doubleValue();
        }
        catch (IOException e) {
            ExceptionLogger.error(ESQueryImpl.class, "searchAvg query error", e);
            return 0.0;
        }
    }

    private Map<String, Long> searchGroupString(SearchSourceBuilder searchBuilder, SearchRequest searchRequest, String aggName, String aggField) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            searchRequest.source(searchBuilder);
            String an = aggName + UUID.randomUUID().toString();
            TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)an).field(aggName + ".keyword");
            SumAggregationBuilder sumb = (SumAggregationBuilder)AggregationBuilders.sum((String)aggField).field(aggField);
            termsBuilder.subAggregation((AggregationBuilder)sumb);
            searchBuilder.aggregation((AggregationBuilder)termsBuilder);
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Map aggMap = response.getAggregations().getAsMap();
            Terms gradeTerms = (Terms)aggMap.get(an);
            List list = gradeTerms.getBuckets();
            for (Object object : list) {
                Terms.Bucket buk = (Terms.Bucket)object;
                Sum sum = (Sum)buk.getAggregations().get(aggField);
                String key = (String)buk.getKey();
                long count = (long)sum.getValue();
                map.put(key, count);
            }
            return map;
        }
        catch (IOException e) {
            ExceptionLogger.error(ESQueryImpl.class, "searchGroupString query error", e);
            return map;
        }
    }

    private Map<String, Long> searchGroupStringMulit(SearchSourceBuilder searchBuilder, SearchRequest searchRequest, String[] aggNames, String aggField) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            searchRequest.source(searchBuilder);
            String roundStr = UUID.randomUUID().toString();
            SumAggregationBuilder sumb = (SumAggregationBuilder)AggregationBuilders.sum((String)aggField).field(aggField);
            TermsAggregationBuilder lastBuilder = null;
            for (String agn : aggNames) {
                TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)(agn + roundStr)).field(agn + ".keyword");
                if (lastBuilder != null) {
                    termsBuilder.subAggregation(lastBuilder);
                } else {
                    termsBuilder.subAggregation((AggregationBuilder)sumb);
                }
                lastBuilder = termsBuilder;
            }
            searchBuilder.aggregation(lastBuilder);
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            this.parseAggregation(response.getAggregations(), map, aggNames.length - 1, aggNames, aggField, "", roundStr);
            return map;
        }
        catch (IOException e) {
            ExceptionLogger.error(ESQueryImpl.class, "searchGroupString query error", e);
            return map;
        }
    }

    private void parseAggregation(Aggregations aggregations, Map<String, Long> map, int i, String[] aggNames, String aggField, String preKey, String roundStr) {
        if (i >= 0) {
            Terms subTerms = (Terms)aggregations.get(aggNames[i] + roundStr);
            List list = subTerms.getBuckets();
            for (Object object : list) {
                Terms.Bucket buk = (Terms.Bucket)object;
                this.parseAggregation(buk.getAggregations(), map, i - 1, aggNames, aggField, preKey + buk.getKeyAsString() + SPLIT, roundStr);
            }
        } else {
            Sum sum = (Sum)aggregations.get(aggField);
            long count = (long)sum.getValue();
            map.put(preKey, count);
        }
    }

    @Override
    public long queryCount(String whereCondition) {
        SearchRequest req = new SearchRequest(new String[]{this.index});
        if (this.version <= 6) {
            req.types(new String[]{this.type});
        }
        req.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = null;
        if (whereCondition != null && whereCondition.length() > 0) {
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
            }
            StringBuilder oql = new StringBuilder(CONDITIONPRE);
            if (whereCondition.trim().toLowerCase(Locale.ENGLISH).startsWith("where")) {
                oql.append(" ").append(whereCondition);
            } else {
                oql.append(" where ").append(whereCondition);
            }
            QueryBuilder qb = (QueryBuilder)Query.fromOQL((String)oql.toString()).getFilter().build(HighLevelFilterBuilder.getInstance());
            boolQueryBuilder.must(qb);
        }
        if (boolQueryBuilder == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery()).from(0).size(1);
        } else {
            sourceBuilder.query(boolQueryBuilder).from(0).size(1);
        }
        req.source(sourceBuilder);
        try {
            SearchResponse res = this.client.search(req, RequestOptions.DEFAULT);
            return res.getHits().getTotalHits();
        }
        catch (IOException e) {
            ExceptionLogger.error(ESQueryImpl.class, "searchGroupString query error", e);
            return 0L;
        }
    }

    @Override
    public List<Map<String, String>> searchCondition(String[] selectfields, String dateFiled, Date fromDate, Date toDate, String whereCondition, int fromIndex, int size, String orderByField, String sortType) {
        SearchRequest req = new SearchRequest(new String[]{this.index});
        if (this.version <= 6) {
            req.types(new String[]{this.type});
        }
        req.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = null;
        if (dateFiled != null && fromDate != null && toDate != null) {
            boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"dts_timestap").gte((Object)DateUtil.addHours(fromDate, 8).getTime()).lte((Object)DateUtil.addHours(toDate, 8).getTime()));
        }
        if (whereCondition != null && whereCondition.length() > 0) {
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
            }
            StringBuilder oql = new StringBuilder(CONDITIONPRE);
            if (whereCondition.trim().toLowerCase(Locale.ENGLISH).startsWith("where")) {
                oql.append(" ").append(whereCondition);
            } else {
                oql.append(" where ").append(whereCondition);
            }
            QueryBuilder qb = (QueryBuilder)Query.fromOQL((String)oql.toString()).getFilter().build(HighLevelFilterBuilder.getInstance());
            boolQueryBuilder.must(qb);
        }
        if (boolQueryBuilder == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery()).from(fromIndex).size(size);
        } else {
            sourceBuilder.query((QueryBuilder)boolQueryBuilder).from(fromIndex).size(size);
        }
        if (orderByField != null) {
            SortBuilder sortBuilder = null;
            sortBuilder = "desc".equals(sortType) ? SortBuilders.fieldSort((String)orderByField).order(SortOrder.DESC) : SortBuilders.fieldSort((String)orderByField).order(SortOrder.ASC);
            sourceBuilder.sort(sortBuilder);
        }
        req.source(sourceBuilder);
        try {
            SearchResponse res = this.client.search(req, RequestOptions.DEFAULT);
            SearchHit[] hits = res.getHits().getHits();
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(4);
            for (SearchHit hit : hits) {
                Map source = hit.getSourceAsMap();
                HashMap<String, String> row = new HashMap<String, String>(4);
                for (String field : selectfields) {
                    Object v = source.get(field);
                    if (v == null) continue;
                    row.put(field, v.toString());
                }
                result.add(row);
            }
            return result;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, DtsErrorCode.ioError, new Object[]{"ESQuery.query error"});
        }
    }

    @Override
    public List<Map<String, Object>> searchConditionAndAgg(String whereCondition, String orderByField, String[] aggNames) {
        SearchRequest req = new SearchRequest(new String[]{this.index});
        if (this.version <= 6) {
            req.types(new String[]{this.type});
        }
        req.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = null;
        if (whereCondition != null && whereCondition.length() > 0) {
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
            }
            StringBuilder oql = new StringBuilder(CONDITIONPRE);
            if (whereCondition.trim().toLowerCase(Locale.ENGLISH).startsWith("where")) {
                oql.append(" ").append(whereCondition);
            } else {
                oql.append(" where ").append(whereCondition);
            }
            QueryBuilder qb = (QueryBuilder)Query.fromOQL((String)oql.toString()).getFilter().build(HighLevelFilterBuilder.getInstance());
            boolQueryBuilder.must(qb);
        }
        if (boolQueryBuilder != null) {
            sourceBuilder.query(boolQueryBuilder).from(0).size(1000);
        }
        TermsAggregationBuilder lastBuilder = null;
        String roundStr = UUID.randomUUID().toString();
        String topField = "top_res";
        TopHitsAggregationBuilder topb = AggregationBuilders.topHits((String)topField).sort(SortBuilders.fieldSort((String)orderByField).order(SortOrder.DESC)).size(1);
        for (String agn : aggNames) {
            TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)(agn + roundStr)).field(agn + ".keyword");
            if (lastBuilder != null) {
                termsBuilder.subAggregation(lastBuilder);
            } else {
                termsBuilder.subAggregation((AggregationBuilder)topb);
            }
            lastBuilder = termsBuilder;
        }
        sourceBuilder.aggregation(lastBuilder);
        req.source(sourceBuilder);
        try {
            SearchResponse res = this.client.search(req, RequestOptions.DEFAULT);
            ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(10);
            this.parseTopAgg(res.getAggregations(), retList, aggNames.length - 1, aggNames, topField, roundStr);
            return retList;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, DtsErrorCode.ioError, new Object[]{"ESQuery.query error"});
        }
    }

    private void parseTopAgg(Aggregations aggregations, List<Map<String, Object>> mList, int i, String[] aggNames, String topField, String roundStr) {
        if (aggregations == null || aggregations.getAsMap() == null || aggregations.getAsMap().size() <= 0) {
            return;
        }
        if (i >= 0) {
            Terms subTerms = (Terms)aggregations.get(aggNames[i] + roundStr);
            List list = subTerms.getBuckets();
            for (Object object : list) {
                Terms.Bucket buk = (Terms.Bucket)object;
                this.parseTopAgg(buk.getAggregations(), mList, i - 1, aggNames, topField, roundStr);
            }
        } else {
            TopHits topHits = (TopHits)aggregations.get(topField);
            for (SearchHit hit : topHits.getHits()) {
                mList.add(hit.getSourceAsMap());
            }
        }
    }
}

