/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.storage.es;

import kd.bos.nosql.operate.CompareType;
import kd.bos.nosql.operate.Filter;
import kd.bos.nosql.operate.FilterBulider;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class HighLevelFilterBuilder
implements FilterBulider<QueryBuilder> {
    private static FilterBulider<QueryBuilder> instance = new HighLevelFilterBuilder();

    public static FilterBulider<QueryBuilder> getInstance() {
        return instance;
    }

    public QueryBuilder composeBulid(CompareType compareType, Filter<QueryBuilder> left, Filter<QueryBuilder> right) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        switch (compareType) {
            case AND: {
                return query.must((QueryBuilder)left.build((FilterBulider)this)).must((QueryBuilder)right.build((FilterBulider)this));
            }
            case OR: {
                return query.should((QueryBuilder)left.build((FilterBulider)this)).should((QueryBuilder)right.build((FilterBulider)this));
            }
        }
        return null;
    }

    public QueryBuilder singleBulid(CompareType compareType, String filed, Object value) {
        String _filed = this.getFiledStoreName(filed);
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        switch (compareType) {
            case EQ: {
                return query.must((QueryBuilder)QueryBuilders.termQuery((String)_filed, (Object)value));
            }
            case NEQ: {
                return query.mustNot((QueryBuilder)QueryBuilders.termQuery((String)_filed, (Object)value));
            }
            case GT: {
                return QueryBuilders.rangeQuery((String)_filed).gt(value);
            }
            case GTE: {
                return QueryBuilders.rangeQuery((String)_filed).gte(value);
            }
            case LT: {
                return QueryBuilders.rangeQuery((String)_filed).lt(value);
            }
            case LTE: {
                return QueryBuilders.rangeQuery((String)_filed).lte(value);
            }
            case IN: {
                return query.must((QueryBuilder)QueryBuilders.termsQuery((String)_filed, (Object[])((Object[])value)));
            }
            case NIN: {
                return query.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)_filed, (Object[])((Object[])value)));
            }
        }
        return QueryBuilders.matchQuery((String)_filed, (Object)value);
    }

    private String getFiledStoreName(String filed) {
        return filed;
    }
}

