/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.OperationContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metric.Meter;
import kd.bos.thread.ThreadEndClear;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.LimiterUtil;
import kd.bos.util.async.SetQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AyncAppenderImpl {
    private CopyOnWriteArrayList appenderList;
    private static Map<Long, ConcurrentLinkedQueue> threadEventsMaps = new ConcurrentHashMap<Long, ConcurrentLinkedQueue>();
    private static Map<Long, AppendTask> runnableMaps = new ConcurrentHashMap<Long, AppendTask>();
    private static SetQueue<AppendTask> setqueue = new SetQueue();
    private static final int maxqueuesize = Integer.getInteger("logback.async.maxqueuesize", 20000);
    private static AtomicInteger totalSpanCount = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(AyncAppenderImpl.class);
    public static final String LIMIT_CODE = "LOG_APPEND";
    public static final String LOG_LIMIT_ENABLE = "limit.log.append.enable";
    public static volatile Method limiterMethod;
    public static volatile Meter logAppenderMeter;
    public static final ThreadLocal<Boolean> isLimited;
    public static final DateTimeFormatter FORMATTER;

    public AyncAppenderImpl(CopyOnWriteArrayList list) {
        this.appenderList = list;
    }

    public void doAppend(Object e) {
        block15: {
            try {
                if (!(e instanceof ILoggingEvent) || ((ILoggingEvent)e).getLevel() != Level.ERROR || !LimiterUtil.isSystemBootFinish() || !AyncAppenderImpl.isLogLimit() || limiterMethod == null) break block15;
                try {
                    limiterMethod.invoke(null, LIMIT_CODE);
                }
                catch (Throwable t) {
                    Throwable te;
                    if (t instanceof InvocationTargetException && (te = ((InvocationTargetException)t).getTargetException()) instanceof KDException && ((KDException)te).getErrorCode() == BosErrorCode.limitOverMaxCount) {
                        if (logAppenderMeter != null) {
                            logAppenderMeter.mark();
                        }
                        if (isLimited.get() == null || !isLimited.get().booleanValue()) {
                            isLimited.set(true);
                        }
                        return;
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        long threadId = Thread.currentThread().getId();
        ConcurrentLinkedQueue spanLs = threadEventsMaps.computeIfAbsent(threadId, k -> {
            runnableMaps.put(threadId, new AppendTask(threadId));
            return new ConcurrentLinkedQueue();
        });
        int spanLssize = totalSpanCount.get();
        if (spanLssize < maxqueuesize) {
            if ((double)spanLssize > (double)maxqueuesize * 0.5 && e instanceof ILoggingEvent && ((ILoggingEvent)e).getLevel().levelInt <= 20000) {
                String formattedDateTime = LocalDateTime.now().format(FORMATTER);
                System.setProperty("log.discard.count", formattedDateTime + " discard info level logs");
                return;
            }
            if ((e = this.preSet(e)) == null) {
                return;
            }
            spanLs.add(new LogEvent(e, this.appenderList));
            totalSpanCount.incrementAndGet();
        } else if (Boolean.getBoolean("logback.async.log.block")) {
            while (totalSpanCount.get() >= maxqueuesize) {
                LockSupport.parkNanos(30000000L);
            }
            if ((e = this.preSet(e)) == null) {
                return;
            }
            spanLs.add(new LogEvent(e, this.appenderList));
            totalSpanCount.incrementAndGet();
        } else {
            int spanSize = spanLs.size();
            String formattedDateTime = LocalDateTime.now().format(FORMATTER);
            System.setProperty("log.discard.count", formattedDateTime + " discard count: " + spanSize);
            totalSpanCount.addAndGet(-1 * spanSize);
            spanLs.clear();
        }
        setqueue.putIfAbsent((Object)runnableMaps.get(threadId));
    }

    private Object preSet(Object e) {
        if (e instanceof LoggingEvent) {
            LoggingEvent _e = (LoggingEvent)e;
            _e.getCallerData();
            _e.getThreadName();
            _e.getMDCPropertyMap();
            String msg = _e.getMessage();
            String formatMsg = _e.getFormattedMessage();
            int maxlength = Integer.getInteger("log.maxlength", 10240);
            if (msg != null && msg.length() > maxlength) {
                msg = msg.substring(0, maxlength) + ".......";
                formatMsg = formatMsg.substring(0, maxlength) + ".......";
                this.setMessage(_e, msg, formatMsg);
            } else if (formatMsg != null && formatMsg.length() > maxlength) {
                formatMsg = formatMsg.substring(0, maxlength) + ".......";
                this.setMessage(_e, msg, formatMsg);
            }
            boolean filterPassword = Boolean.parseBoolean(System.getProperty("log.filter.pwd"));
            if (msg != null && filterPassword && msg.indexOf("password") > 0) {
                return null;
            }
        }
        return e;
    }

    private void setMessage(LoggingEvent _e, String msg, String formatMsg) {
        try {
            Field f = LoggingEvent.class.getDeclaredField("message");
            f.setAccessible(true);
            f.set(_e, msg);
            f = LoggingEvent.class.getDeclaredField("formattedMessage");
            f.setAccessible(true);
            f.set(_e, formatMsg);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
    }

    public static boolean isLogLimit() {
        return Boolean.parseBoolean(System.getProperty(LOG_LIMIT_ENABLE, "false"));
    }

    static {
        isLimited = new ThreadLocal();
        FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < 3; ++i) {
            Thread t = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            AppendTask runnable;
                            if ((runnable = (AppendTask)setqueue.poll()) == null) {
                                LockSupport.parkNanos(10000000L);
                                continue;
                            }
                            runnable.run();
                        }
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.flush();
                        System.setProperty("monitor.logback.taskException", sw.toString());
                        LockSupport.parkNanos(100000000L);
                        continue;
                    }
                    break;
                }
            }, "LogAyncAppender-" + i);
            t.setDaemon(true);
            t.start();
        }
        ThreadEndClear.addListener(threadidSet -> {
            ArrayList remove = new ArrayList();
            threadEventsMaps.forEach((k, v) -> {
                if (!threadidSet.contains(k)) {
                    if (v.isEmpty()) {
                        remove.add(k);
                    } else {
                        setqueue.putIfAbsent((Object)runnableMaps.get(k));
                    }
                }
            });
            remove.forEach(k -> {
                runnableMaps.remove(k);
                threadEventsMaps.remove(k);
            });
        });
    }

    private static class AppendTask {
        private long threadid;

        AppendTask(long threadid) {
            this.threadid = threadid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ConcurrentLinkedQueue eventLs = (ConcurrentLinkedQueue)threadEventsMaps.get(this.threadid);
            if (eventLs != null && eventLs.size() > 0) {
                ConcurrentLinkedQueue concurrentLinkedQueue = eventLs;
                synchronized (concurrentLinkedQueue) {
                    if (eventLs != null && eventLs.size() > 0) {
                        LogEvent le;
                        int size = eventLs.size();
                        Map taginfo = null;
                        OperationContext oc = null;
                        for (int i = 0; i < size && (le = (LogEvent)eventLs.poll()) != null; ++i) {
                            totalSpanCount.decrementAndGet();
                            if (le.taginfo != taginfo) {
                                taginfo = le.taginfo;
                                if (taginfo == null) {
                                    ThreadTruck.remove((Object)"rcinfo");
                                } else {
                                    ThreadTruck.put((Object)"rcinfo", (Object)taginfo);
                                }
                            }
                            if (le.oc != oc) {
                                oc = le.oc;
                                if (oc == null) {
                                    OperationContext.remove();
                                } else {
                                    OperationContext.set((OperationContext)oc);
                                }
                            }
                            for (Object appender : le.appenderList) {
                                ((Appender)appender).doAppend(le.event);
                            }
                        }
                    }
                }
                ThreadTruck.remove((Object)"rcinfo");
                OperationContext.remove();
            }
        }
    }

    private static class LogEvent {
        private Object event;
        private Map<String, String> taginfo = null;
        private OperationContext oc;
        private CopyOnWriteArrayList appenderList;

        LogEvent(Object o, CopyOnWriteArrayList appenderList) {
            this.event = o;
            this.taginfo = (Map)ThreadTruck.get((Object)"rcinfo");
            this.oc = OperationContext.get();
            if (this.oc != null) {
                this.oc = this.oc.copy();
            }
            this.appenderList = appenderList;
        }
    }
}

