/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging;

import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.bos.logging.logback.LogbackSlowLogger;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkPublic
public abstract class LogFactory {
    private static LogFactory factory = LogFactory.initFactory();
    private static final String LOGFACTORY_CLASS = "logfactory.className";
    private static final Logger logger = LoggerFactory.getLogger(LogFactory.class);

    public static Log getLog(Class<?> clazz) {
        return factory._getLog(clazz.getName());
    }

    @SdkInternal
    @Deprecated
    public static Log getLog(Class<?> clazz, String appId) {
        return factory._getLog(clazz.getName());
    }

    public static Log getLog(String name) {
        return factory._getLog(name);
    }

    @SdkInternal
    protected abstract Log _getLog(String var1);

    private static LogFactory initFactory() {
        if (LogFactory.isDefaultLogfactoryClass()) {
            LogbackFactory factory = new LogbackFactory();
            return factory;
        }
        String className = System.getProperty(LOGFACTORY_CLASS);
        return LogFactory.createByClassName(className);
    }

    private static boolean isDefaultLogfactoryClass() {
        String className = System.getProperty(LOGFACTORY_CLASS);
        return StringUtils.isEmpty((String)className);
    }

    private static LogFactory createByClassName(String className) {
        LogFactory logFactory = null;
        try {
            Class<?> clazz = Class.forName(className);
            logFactory = (LogFactory)clazz.newInstance();
        }
        catch (Exception e) {
            logger.error("Error: Can't create LogFactory by class:" + className, (Throwable)e);
        }
        return logFactory;
    }

    static {
        LogbackSlowLogger.init();
    }
}

