/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.slowlog.SlowLogger;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class LogbackSlowLogger
extends SlowLogger {
    private static Log log = LogFactory.getLog("SlowLogger");
    private static final String slowLogerLevelKey = "slowlogger.level";
    private static SlowLogger slowLoger;

    protected void log0(String message) {
        log.error(message);
    }

    public static void init() {
        SlowLogger.setInstance((SlowLogger)slowLoger);
    }

    private static void initSlowLogger() {
        String logLevel = System.getProperty(slowLogerLevelKey, "error");
        slowLoger = "warn".equalsIgnoreCase(logLevel) ? new WarnSlowLogger() : ("info".equalsIgnoreCase(logLevel) ? new InfoSlowLogger() : ("debug".equalsIgnoreCase(logLevel) ? new DebugSlowLogger() : new ErrorSlowLogger()));
    }

    static {
        LogbackSlowLogger.initSlowLogger();
        ConfigurationUtil.observeChange((String)slowLogerLevelKey, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                LogbackSlowLogger.initSlowLogger();
                LogbackSlowLogger.init();
            }
        });
    }

    static class InfoSlowLogger
    extends SlowLogger {
        InfoSlowLogger() {
        }

        protected void log0(String message) {
            log.info(message);
        }
    }

    static class DebugSlowLogger
    extends SlowLogger {
        DebugSlowLogger() {
        }

        protected void log0(String message) {
            log.debug(message);
        }
    }

    static class WarnSlowLogger
    extends SlowLogger {
        WarnSlowLogger() {
        }

        protected void log0(String message) {
            log.warn(message);
        }
    }

    static class ErrorSlowLogger
    extends SlowLogger {
        ErrorSlowLogger() {
        }

        protected void log0(String message) {
            log.error(message);
        }
    }
}

