/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LogSpecialLevel;
import java.util.Map;
import kd.bos.logging.logback.filter.LogFilter;
import kd.bos.thread.ThreadTruck;
import org.slf4j.Marker;

public class SpecialLevelFilter
extends TurboFilter {
    private static final boolean logLevelFilterEnable = Boolean.getBoolean("log.level.filter.enable");
    private static final boolean logRuleFilterEnable = !Boolean.getBoolean("log.rule.filter.disable");

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (logLevelFilterEnable) {
            Level tagLevel;
            Map taginfo = (Map)ThreadTruck.get((Object)"rcinfo");
            if (taginfo != null && (tagLevel = LogSpecialLevel.getLevel(taginfo)) != null && tagLevel.levelInt <= level.levelInt) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.NEUTRAL;
        }
        if (logRuleFilterEnable) {
            try {
                return LogFilter.decide(logger, level);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FilterReply.NEUTRAL;
    }
}

