/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.kafka;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import kd.bos.logging.logback.kafka.IKafkaSender;
import kd.bos.logging.logback.kafka.KafkaBlockingQueue;
import kd.bos.logging.logback.kafka.KafkaLogbackConfigBase;
import kd.bos.logging.logback.kafka.KafkaMessage;
import kd.bos.logging.logback.kafka.KafkaSender;
import kd.bos.logging.logback.kafka.LoggerFormat;
import kd.bos.util.JSONUtils;

public class KafkaAppender
extends KafkaLogbackConfigBase<ILoggingEvent> {
    protected IKafkaSender<String> kafkaSender;
    private LoggerFormat loggerFormat = new LoggerFormat();

    public void start() {
        super.start();
        Properties props = this.getProducerProperties();
        if (this.syncSend) {
            this.kafkaSender = new KafkaSender<String>(props);
        } else {
            this.kafkaSender = new KafkaSender<String>(props);
            KafkaBlockingQueue.init(this.kafkaSender);
        }
    }

    public void stop() {
        super.stop();
        if (this.syncSend && this.kafkaSender != null) {
            this.kafkaSender.close();
            this.kafkaSender = null;
        }
    }

    protected void append(ILoggingEvent event) {
        Map<Object, Object> logObject = this.loggerFormat.convert(event);
        try {
            this.send(new KafkaMessage<String>(this.topic, JSONUtils.toString(logObject)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void send(KafkaMessage<String> msg) {
        if (this.syncSend) {
            this.kafkaSender.send(msg);
        } else {
            KafkaBlockingQueue.offer(msg);
        }
    }
}

