/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.kafka;

import java.util.concurrent.ArrayBlockingQueue;
import kd.bos.logging.logback.kafka.IKafkaSender;
import kd.bos.logging.logback.kafka.KafkaMessage;
import kd.bos.metric.Gauge;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBlockingQueue {
    private static int QUEUE_CAPACITY = 10000;
    private static ArrayBlockingQueue<KafkaMessage<?>> queue = null;
    private static IKafkaSender<?> kafkaSender;
    private static boolean STOPFLAG;
    private static final String config_prefix_key = "metric.log.kafka.prefix";
    private static String prefix;
    private static Gauge<Integer> queueSize;
    private static Meter discardCount;
    private static final Logger logger;

    public static void init(IKafkaSender<?> ikafkaSender) {
        kafkaSender = ikafkaSender;
        STOPFLAG = false;
        Thread thread = new Thread((Runnable)new Poll(), "log-kafka-pull");
        thread.setDaemon(true);
        thread.start();
        prefix = System.getProperty(config_prefix_key, prefix);
        queueSize = new Gauge<Integer>(){

            public Integer getValue() {
                return queue.size();
            }
        };
        MetricSystem.registerGauge((String)KafkaBlockingQueue.name("queueSize"), queueSize);
        discardCount = MetricSystem.meter((String)KafkaBlockingQueue.name("discardCount"));
    }

    private static String name(String suffix) {
        return prefix + suffix;
    }

    public static void offer(KafkaMessage<?> msg) {
        boolean success = queue.offer(msg);
        if (!success) {
            discardCount.mark();
        }
    }

    public static void stop() {
        STOPFLAG = true;
    }

    static {
        STOPFLAG = false;
        prefix = "kd.metrics.log.kafka.";
        logger = LoggerFactory.getLogger(KafkaBlockingQueue.class);
        int capacity = ConfigurationUtil.getInteger((String)"log.kafka.queue.capacity", (Integer)QUEUE_CAPACITY);
        queue = new ArrayBlockingQueue(capacity);
    }

    static class Poll
    implements Runnable {
        Poll() {
        }

        @Override
        public void run() {
            while (!STOPFLAG) {
                try {
                    KafkaMessage msg = (KafkaMessage)queue.take();
                    kafkaSender.send(msg);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

