/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.kafka;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.util.Properties;
import kd.bos.encrypt.Encrypters;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.config.ConfigException;

public abstract class KafkaLogbackConfigBase<I extends DeferredProcessingAware>
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final String COMPRESSION_TYPE_CONFIG = "compression.type";
    private static final String ACKS_CONFIG = "acks";
    private static final String RETRIES_CONFIG = "retries";
    private static final String KEY_SERIALIZER_CLASS_CONFIG = "key.serializer";
    private static final String VALUE_SERIALIZER_CLASS_CONFIG = "value.serializer";
    private static final String SECURITY_PROTOCOL = "security.protocol";
    private static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    private static final String SSL_TRUSTSTORE_PASSWORD = "ssl.truststore.password";
    private static final String SSL_KEYSTORE_TYPE = "ssl.keystore.type";
    private static final String SSL_KEYSTORE_LOCATION = "ssl.keystore.location";
    private static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
    private static final String SASL_JAAS_CONFIG = "sasl.jaas.config";
    private static final String SASL_MECHANISM = "sasl.mechanism";
    private static final String ENABLE_IDEMPOTENCE = "enable.idempotence";
    protected String brokerList = null;
    protected String topic = null;
    protected String compressionType = null;
    protected String keySerializerClass = null;
    protected String valueSerializerClass = null;
    protected String securityProtocol = null;
    protected String sslTruststoreLocation = null;
    protected String sslTruststorePassword = null;
    protected String sslKeystoreType = null;
    protected String sslKeystoreLocation = null;
    protected String sslKeystorePassword = null;
    protected String clientJaasConfPath = null;
    protected String kerb5ConfPath = null;
    protected String saslMechanism = null;
    protected String enableIdempotence = null;
    protected int retries = 0;
    protected int requiredNumAcks = Integer.MAX_VALUE;
    protected boolean syncSend = false;
    protected Encoder<ILoggingEvent> encoder;
    protected String userName = null;
    protected String password = null;

    protected Properties getProducerProperties() {
        Properties props = new Properties();
        if (this.brokerList != null) {
            props.put(BOOTSTRAP_SERVERS_CONFIG, this.brokerList);
            System.setProperty(BOOTSTRAP_SERVERS_CONFIG, this.brokerList);
        }
        if (props.isEmpty()) {
            throw new ConfigException("The bootstrap servers property should be specified");
        }
        if (this.topic == null) {
            throw new ConfigException("Topic must be specified by the Kafka Logback appender");
        }
        if (this.compressionType != null) {
            props.put(COMPRESSION_TYPE_CONFIG, this.compressionType);
        }
        if (this.requiredNumAcks != Integer.MAX_VALUE) {
            props.put(ACKS_CONFIG, Integer.toString(this.requiredNumAcks));
        }
        if (this.retries > 0) {
            props.put(RETRIES_CONFIG, Integer.toString(this.retries));
        }
        if (this.securityProtocol != null) {
            props.put(SECURITY_PROTOCOL, this.securityProtocol);
            if (this.securityProtocol.contains("SSL") && this.sslTruststoreLocation != null && this.sslTruststorePassword != null) {
                props.put(SSL_TRUSTSTORE_LOCATION, this.sslTruststoreLocation);
                props.put(SSL_TRUSTSTORE_PASSWORD, this.sslTruststorePassword);
                if (this.sslKeystoreType != null && this.sslKeystoreLocation != null && this.sslKeystorePassword != null) {
                    props.put(SSL_KEYSTORE_TYPE, this.sslKeystoreType);
                    props.put(SSL_KEYSTORE_LOCATION, this.sslKeystoreLocation);
                    props.put(SSL_KEYSTORE_PASSWORD, this.sslKeystorePassword);
                }
            } else if ("SASL_PLAINTEXT".equals(this.securityProtocol)) {
                String config = KafkaLogbackConfigBase.getKafkaAuthConfig(this.userName, this.password);
                String mechanism = this.saslMechanism == null ? "PLAIN" : this.saslMechanism;
                props.put(SASL_MECHANISM, mechanism);
                props.put(SECURITY_PROTOCOL, this.securityProtocol);
                props.put(SASL_JAAS_CONFIG, config);
            } else if (this.securityProtocol.equals("SSL") && this.sslTruststoreLocation != null) {
                props.put(SSL_TRUSTSTORE_LOCATION, this.sslTruststoreLocation);
            }
        }
        if (this.keySerializerClass != null) {
            props.put(KEY_SERIALIZER_CLASS_CONFIG, this.keySerializerClass);
        } else {
            props.put(KEY_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringSerializer");
        }
        if (this.valueSerializerClass != null) {
            props.put(VALUE_SERIALIZER_CLASS_CONFIG, this.valueSerializerClass);
        } else {
            props.put(VALUE_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.ByteArraySerializer");
        }
        if (this.enableIdempotence != null) {
            props.put(ENABLE_IDEMPOTENCE, this.enableIdempotence);
        }
        return props;
    }

    private static String getKafkaAuthConfig(String userName, String pw) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            throw new ConfigException("Config item 'userName' of kafka appender can't be empty when securityProtocol is 'SASL_PLAINTEXT'.");
        }
        if (StringUtils.isEmpty((CharSequence)pw)) {
            throw new ConfigException("Config item 'password' of kafka appender can't be empty when securityProtocol is 'SASL_PLAINTEXT'.");
        }
        System.setProperty("logKafkaUser", userName);
        System.setProperty("logKafkaPwd", pw);
        return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + userName + "\" password=\"" + pw + "\";";
    }

    public void setBrokerList(String brokerList) {
        this.brokerList = brokerList;
    }

    public void setRequiredNumAcks(int requiredNumAcks) {
        this.requiredNumAcks = requiredNumAcks;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSyncSend(boolean syncSend) {
        this.syncSend = syncSend;
    }

    public void setKeySerializerClass(String clazz) {
        this.keySerializerClass = clazz;
    }

    public void setValueSerializerClass(String clazz) {
        this.valueSerializerClass = clazz;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public void setSslKeystoreLocation(String sslKeystoreLocation) {
        this.sslKeystoreLocation = sslKeystoreLocation;
    }

    public void setKerb5ConfPath(String kerb5ConfPath) {
        this.kerb5ConfPath = kerb5ConfPath;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = Encrypters.decode((String)password);
    }

    public void setEnableIdempotence(String enableIdempotence) {
        this.enableIdempotence = enableIdempotence;
    }
}

