/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.kafka;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import kd.bos.context.OperationContext;
import kd.bos.instance.Instance;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class LoggerFormat {
    private static final String KAFKA_CUSTOM_TAGS = "log.kafka.customTags";
    private static final String TRACE_PREFIX = CoreConstants.LINE_SEPARATOR + "    ";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    private static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)UTC);
    private static final FastDateFormat LOCAL_DATETIME_TIME_ZONE_FORMAT_WITH_MILLS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)DEFAULT_TIME_ZONE);
    private long lastTimestamp = -1L;
    private long lastLocalTimestamp = -1L;
    private String timestampStrCache = null;
    private String localTimestampStrCache = null;
    private static int shortMessageLength = 256;
    private static String localIp;
    private static Properties props;
    private static final String[] notShowClass;

    public Map<Object, Object> convert(ILoggingEvent event) {
        return this.convert(event, props);
    }

    private static Properties getCustomMessage() {
        String customConfig = System.getProperty(KAFKA_CUSTOM_TAGS);
        if (customConfig == null) {
            return null;
        }
        try {
            Properties props = new Properties();
            props.load(IOUtils.toInputStream((String)customConfig));
            return props;
        }
        catch (IOException e) {
            DisCardUtil.discard();
            return null;
        }
    }

    public Map<Object, Object> convert(ILoggingEvent event, Properties props) {
        String args1;
        Object[] args;
        OperationContext oc;
        StackTraceElement[] cda;
        HashMap<Object, Object> map = new HashMap<Object, Object>(16);
        map.put("clusterName", Instance.getClusterName());
        map.put("appName", Instance.getAppName());
        map.put("instanceId", Instance.getInstanceId());
        map.put("ip", localIp);
        map.put("time", this.getTime(event));
        map.put("@timestamp", this.getLocalTime(event));
        map.put("level", event.getLevel().toString());
        String message = event.getFormattedMessage();
        if (event.getThrowableProxy() != null) {
            String exceptionMessage = event.getThrowableProxy().getMessage();
            if (message == null) {
                message = exceptionMessage;
            } else if (exceptionMessage != null && message.length() != exceptionMessage.length()) {
                message = message + CoreConstants.LINE_SEPARATOR + exceptionMessage;
            }
            map.put("exceptionClass", event.getThrowableProxy().getClassName());
            String stacktrace = this.renderStacktrace(event);
            if (stacktrace != null) {
                if (stacktrace.length() > shortMessageLength) {
                    map.put("stacktrace", stacktrace.substring(0, shortMessageLength));
                    map.put("stacktrace2", stacktrace.substring(shortMessageLength));
                } else {
                    map.put("stacktrace", stacktrace);
                }
            }
        }
        if (message != null) {
            if (message.length() > shortMessageLength) {
                map.put("message", message.substring(0, shortMessageLength));
                map.put("message2", message.substring(shortMessageLength));
            } else {
                map.put("message", message);
            }
        }
        if (!this.fillMore(cda = event.getCallerData(), map)) {
            map.put("className", event.getLoggerName());
            map.put("methodName", this.getMethodName(cda));
            map.put("line", this.getLineNumber(cda));
        }
        HashMap<String, String> taginfo = new HashMap<String, String>(8);
        Map rcinfo = (Map)ThreadTruck.get((Object)"rcinfo");
        if (rcinfo != null) {
            this.logDesensitize(rcinfo);
            taginfo.putAll(rcinfo);
        }
        if ((oc = OperationContext.get()) != null) {
            taginfo.put("appId", oc.getAppId());
            taginfo.put("formId", oc.getFormId());
            taginfo.put("formName", oc.getFormName());
            taginfo.put("opKey", oc.getOpKey());
            taginfo.put("opMethod", oc.getOpMethod());
            String tenantId = oc.getTenantId();
            if (StringUtils.isNotEmpty((String)tenantId) && !taginfo.containsKey("tenantId")) {
                taginfo.put("tenantId", tenantId);
            }
        }
        if (taginfo.size() > 0) {
            map.put("logtags", taginfo);
        }
        if (props != null) {
            map.putAll(props);
        }
        if ((args = event.getArgumentArray()) != null && args.length >= 2 && args[0] != null && "SlowLogger".equals(args1 = args[0].toString())) {
            map.put("cost", args[1]);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTime(ILoggingEvent le) {
        long timestamp = le.getTimeStamp();
        LoggerFormat loggerFormat = this;
        synchronized (loggerFormat) {
            if (timestamp == this.lastTimestamp) {
                return this.timestampStrCache;
            }
            this.lastTimestamp = timestamp;
            this.timestampStrCache = ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLS.format(timestamp);
            return this.timestampStrCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalTime(ILoggingEvent le) {
        long timestamp = le.getTimeStamp();
        LoggerFormat loggerFormat = this;
        synchronized (loggerFormat) {
            if (timestamp == this.lastLocalTimestamp) {
                return this.localTimestampStrCache;
            }
            this.lastLocalTimestamp = timestamp;
            this.localTimestampStrCache = LOCAL_DATETIME_TIME_ZONE_FORMAT_WITH_MILLS.format(timestamp);
            return this.localTimestampStrCache;
        }
    }

    private boolean fillMore(StackTraceElement[] cda, Map<Object, Object> map) {
        if (cda != null) {
            for (StackTraceElement trace : cda) {
                String className = trace.getClassName();
                if (this.matchNotShowClass(className)) continue;
                this.fill(trace, map);
                return true;
            }
        }
        return false;
    }

    private boolean matchNotShowClass(String className) {
        for (String s : notShowClass) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void fill(StackTraceElement trace, Map<Object, Object> map) {
        map.put("className", trace.getClassName());
        map.put("line", trace.getLineNumber());
        map.put("methodName", trace.getMethodName());
    }

    private int getLineNumber(StackTraceElement[] cda) {
        if (cda != null && cda.length > 0) {
            return cda[0].getLineNumber();
        }
        return -1;
    }

    private String getMethodName(StackTraceElement[] cda) {
        if (cda != null && cda.length > 0) {
            return cda[0].getMethodName();
        }
        return "?";
    }

    private String renderStacktrace(ILoggingEvent event) {
        StringBuilder sbuf = new StringBuilder();
        for (IThrowableProxy tp = event.getThrowableProxy(); tp != null; tp = tp.getCause()) {
            this.renderStacktrace(sbuf, tp);
        }
        return sbuf.toString();
    }

    private void renderStacktrace(StringBuilder sbuf, IThrowableProxy tp) {
        this.printFirstLine(sbuf, tp);
        int commonFrames = tp.getCommonFrames();
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        for (int i = 0; i < stepArray.length - commonFrames; ++i) {
            StackTraceElementProxy step = stepArray[i];
            sbuf.append(TRACE_PREFIX);
            sbuf.append(step.toString());
        }
        if (commonFrames > 0) {
            sbuf.append(TRACE_PREFIX);
            sbuf.append("\t... ").append(commonFrames).append(" common frames omitted");
        }
    }

    private void printFirstLine(StringBuilder sb, IThrowableProxy tp) {
        int commonFrames = tp.getCommonFrames();
        if (commonFrames > 0) {
            sb.append(CoreConstants.LINE_SEPARATOR).append("Caused by: ");
        }
        sb.append(tp.getClassName()).append(": ").append(tp.getMessage());
    }

    private void logDesensitize(Map<String, String> rcinfo) {
        String enablePrivacy = System.getProperty("monitor.privacy.enable", "false");
        if ("true".equalsIgnoreCase(enablePrivacy)) {
            rcinfo.put("userName", null);
            rcinfo.put("userId", null);
        }
    }

    static {
        props = LoggerFormat.getCustomMessage();
        notShowClass = new String[]{"kd.bos.logging", "kd.bos.dts.exception.ExceptionLogger", "kd.bos.mq.rabbit.ExceptionLogger", "com.alibaba.dubbo.common.logger", "kd.bos.response.ResponseHeaderImpl"};
        InetAddress ia = null;
        try {
            ia = InetAddress.getLocalHost();
            localIp = ia.getHostAddress();
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }
}

