/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveCascadeConfigEntity;
import kd.bos.archive.entity.ArchiveIndexConfigEntity;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.repository.ArchiveCascadeConfigRepository;
import kd.bos.archive.repository.ArchiveIndexConfigRepository;
import kd.bos.archive.task.config.ArchiveIndexDefine;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ArchiveIndexConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;

public class ArchiveConfigUtil {
    private static Class<?> linkEntryType;
    private static Class<?> mulBasedataPropType;
    private static Method getLinkSet;
    private static Method getTrackerTable;
    private static Method getWbSnapTable;

    public static List<ArchiveConfig> toArchiveConfigs(String entitynumber, String archiveRoute, String logicSuffix) {
        LogicArchiveRoute logicArchiveRoute = null;
        if (archiveRoute != null) {
            logicArchiveRoute = LogicArchiveRoute.of((String)archiveRoute);
        }
        if (logicSuffix == null && logicArchiveRoute != null) {
            logicSuffix = logicArchiveRoute.getLogicSuffix();
        }
        ArrayList<ArchiveConfig> ret = new ArrayList<ArchiveConfig>(10);
        IDataEntityType dt = ORM.create().getDataEntityType(entitynumber);
        ArchiveConfig rootConfig = ArchiveConfig.table((String)dt.getName().toLowerCase(), (String)dt.getAlias(), (String)(dt.getAlias() + logicSuffix), (String)(logicArchiveRoute != null ? logicArchiveRoute.getRealArchiveKey() : null), (int)0, (String)dt.getPrimaryKey().getAlias());
        ret.add(rootConfig);
        try {
            String tc;
            Object linkSet = getLinkSet.invoke(null, entitynumber);
            if (linkSet != null && (tc = (String)getTrackerTable.invoke(linkSet, new Object[0])) != null && tc.trim().length() > 0) {
                tc = tc.trim().toLowerCase();
                ArchiveConfig tcConfig = ArchiveConfig.childrenTable((String)(dt.getName().toLowerCase() + ".track"), (String)tc, (String)(tc + logicSuffix), (String)"FTBillId", (String)dt.getPrimaryKey().getAlias(), (ArchiveConfig)rootConfig, (String)"FID");
                ((ChildrenArchiveConfig)tcConfig).setTcTableConfig();
                String wb = (String)getWbSnapTable.invoke(linkSet, new Object[0]);
                ret.add(tcConfig);
                if (wb != null && wb.trim().length() > 0) {
                    wb = wb.trim().toLowerCase();
                    ArchiveConfig wbConfig = ArchiveConfig.childrenTable((String)(dt.getName().toLowerCase() + ".wb"), (String)wb, (String)(wb + logicSuffix), (String)"FID", (String)"FID", (ArchiveConfig)tcConfig, (String)"FEntryId");
                    ((ChildrenArchiveConfig)wbConfig).setWbTableConfig();
                    ret.add(wbConfig);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        ArchiveConfigUtil.collectShardingConfig(dt, true, rootConfig, logicSuffix, ret);
        return ret;
    }

    private static void collectShardingConfig(IDataEntityType dt, boolean rootDT, ArchiveConfig parent, String logicSuffix, List<ArchiveConfig> list) {
        ArchiveConfig currentLevelShardingConfig = parent;
        if (!rootDT) {
            String pkField = dt.getParent().getPrimaryKey().getAlias();
            String childrenName = parent.getName() + '.' + dt.getName().toLowerCase();
            ArchiveConfig children = ArchiveConfig.childrenTable((String)childrenName, (String)dt.getAlias(), (String)(dt.getAlias() + logicSuffix), (String)pkField, (String)pkField, (ArchiveConfig)parent, (String)ORM.create().getDataEntityType(childrenName).getPrimaryKey().getAlias());
            list.add(children);
            currentLevelShardingConfig = children;
        }
        ArrayList<ArchiveConfig> childList = new ArrayList<ArchiveConfig>(10);
        HashSet<String> tableGroupSet = new HashSet<String>();
        DataEntityPropertyCollection dps = dt.getProperties();
        int n = dps.size();
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty dp = (IDataEntityProperty)dps.get(i);
            ArchiveConfigUtil.collectShardingConfig(dp, tableGroupSet, currentLevelShardingConfig, logicSuffix, childList);
        }
        String pkField = dt.getPrimaryKey().getAlias();
        String name = rootDT ? dt.getName().toLowerCase() : parent.getName() + '.' + dt.getName().toLowerCase();
        for (String ext : tableGroupSet) {
            ArchiveConfig extConfig = ArchiveConfig.childrenTable((String)name, (String)(dt.getAlias() + '_' + ext), (String)(dt.getAlias() + '_' + ext + logicSuffix), (String)pkField, (String)pkField, (ArchiveConfig)currentLevelShardingConfig, (String)ORM.create().getDataEntityType(name).getPrimaryKey().getAlias());
            ArchiveConfigUtil.setAttr(extConfig);
            list.add(extConfig);
        }
        if (!childList.isEmpty()) {
            list.addAll(childList);
        }
    }

    private static void collectShardingConfig(IDataEntityProperty dp, Set<String> tableGroupSet, ArchiveConfig currentLevelShardingConfig, String logicSuffix, List<ArchiveConfig> childList) {
        if (dp instanceof ICollectionProperty) {
            if (dp instanceof DynamicLocaleProperty) {
                tableGroupSet.add("L");
            } else {
                IDataEntityType itemDT = ((ICollectionProperty)dp).getItemType();
                if (IEntryType.class.isAssignableFrom(itemDT.getClass()) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0) {
                    Class<?> cls = itemDT.getClass();
                    if (linkEntryType.isAssignableFrom(cls)) {
                        String pkField = itemDT.getParent().getPrimaryKey().getAlias();
                        String childrenName = currentLevelShardingConfig.getName() + '.' + itemDT.getName().toLowerCase();
                        ArchiveConfig children = ArchiveConfig.childrenTable((String)childrenName, (String)itemDT.getAlias(), (String)(itemDT.getAlias() + logicSuffix), (String)pkField, (String)pkField, (ArchiveConfig)currentLevelShardingConfig, (String)ORM.create().getDataEntityType(childrenName).getPrimaryKey().getAlias());
                        ((ChildrenArchiveConfig)children).setLkTableConfig();
                        childList.add(children);
                    } else {
                        ArchiveConfigUtil.collectShardingConfig(itemDT, false, currentLevelShardingConfig, logicSuffix, childList);
                    }
                }
                if (mulBasedataPropType.isAssignableFrom(dp.getClass()) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0) {
                    ArchiveConfigUtil.collectShardingConfig(itemDT, false, currentLevelShardingConfig, logicSuffix, childList);
                }
            }
        } else if (!(dp instanceof IComplexProperty) && !ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp)) {
            String tableGroup;
            if (ORMUtil.isDbIgnore((IDataEntityProperty)dp)) {
                // empty if block
            }
            if ((tableGroup = dp.getTableGroup()) != null && tableGroup.length() > 0) {
                tableGroupSet.add(tableGroup.toUpperCase());
            }
        }
    }

    private static void setAttr(ArchiveConfig sc) {
        if (sc.getTable().endsWith("_l")) {
            ((ChildrenArchiveConfig)sc).setLangTableConfig();
        } else {
            ((ChildrenArchiveConfig)sc).setGroupTableConfig();
        }
    }

    public static boolean isLangOrGroupTableDBConfig(ArchiveConfig sc) {
        return ArchiveConfigUtil.isLangTableDBConfig(sc) || ArchiveConfigUtil.isGroupTableDBConfig(sc);
    }

    public static boolean isLangTableDBConfig(ArchiveConfig sc) {
        return sc instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)sc).isLangTableConfig();
    }

    public static boolean isGroupTableDBConfig(ArchiveConfig sc) {
        return sc instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)sc).isGroupTableConfig();
    }

    public static boolean isTcTableDBConfig(ArchiveConfig sc) {
        return sc instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)sc).isTcTableConfig();
    }

    public static boolean isWbTableDBConfig(ArchiveConfig sc) {
        return sc instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)sc).isWbTableConfig();
    }

    public static boolean isLkTableDBConfig(ArchiveConfig sc) {
        return sc instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)sc).isLkTableConfig();
    }

    public static List<ArchiveCascadeConfigEntity> toArchiveCascadeConfigs(ArchiveCascadeConfigEntity cascadeConfig) {
        ArrayList<ArchiveCascadeConfigEntity> ret = new ArrayList<ArchiveCascadeConfigEntity>();
        ret.add(cascadeConfig);
        ArchiveConfigUtil.collectCascadeConfigList(ret, cascadeConfig);
        return ret;
    }

    private static void collectCascadeConfigList(List<ArchiveCascadeConfigEntity> cascadeConfigList, ArchiveCascadeConfigEntity cascadeConfig) {
        List<ArchiveCascadeConfigEntity> childCascadeConfigs = ArchiveCascadeConfigRepository.get().loadCascadeChildConfig(cascadeConfig.getEntitynumber());
        for (ArchiveCascadeConfigEntity cascadeConfigEntity : childCascadeConfigs) {
            cascadeConfigEntity.setParentCascadeConfig(cascadeConfig);
            cascadeConfigList.add(cascadeConfigEntity);
            ArchiveConfigUtil.collectCascadeConfigList(cascadeConfigList, cascadeConfigEntity);
        }
    }

    public static ArchiveIndexConfig toArchiveIndexConfig(String entitynumber) {
        ArchiveIndexConfigEntity indexConfigEntity = ArchiveIndexConfigRepository.get().loadIndexConfig(entitynumber);
        if (indexConfigEntity != null && indexConfigEntity.getIndicesProperties() != null && indexConfigEntity.getIndicesProperties().length > 0) {
            IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)entitynumber, null);
            String tableName = rootDT.getAlias();
            ArchiveIndexDefine[] archiveIndexDefines = null;
            String[] indexFields = null;
            archiveIndexDefines = new ArchiveIndexDefine[indexConfigEntity.getIndicesProperties().length];
            indexFields = new String[indexConfigEntity.getIndicesProperties().length];
            int i = 0;
            for (String p : indexConfigEntity.getIndicesProperties()) {
                archiveIndexDefines[i] = ArchiveUtil.createIndexDefile(p, rootDT);
                indexFields[i] = archiveIndexDefines[i].getField();
                ++i;
            }
            boolean indexTbExists = false;
            if (indexFields != null) {
                indexTbExists = DB.exitsTableForManager((DBRoute)DBRoute.of((String)rootDT.getDBRouteKey()), (String)ArchiveName.of((String)tableName).getArchivePkTable());
            }
            ArchiveIndexConfig indexConfig = new ArchiveIndexConfig(tableName, indexFields);
            indexConfig.setIndexTbExists(indexTbExists);
            return indexConfig;
        }
        return null;
    }

    static {
        try {
            linkEntryType = Class.forName("kd.bos.entity.LinkEntryType");
            mulBasedataPropType = Class.forName("kd.bos.entity.property.MulBasedataProp");
            getLinkSet = Class.forName("kd.bos.entity.EntityMetadataCache").getMethod("getLinkSet", String.class);
            Class<?> ecls = Class.forName("kd.bos.entity.LinkSetElement");
            getTrackerTable = ecls.getMethod("getTrackerTable", new Class[0]);
            getWbSnapTable = ecls.getMethod("getWbSnapTable", new Class[0]);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

