/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.ArchiveTaskRuntime;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveCrossInfoEntity;
import kd.bos.archive.entity.ArchiveDatabaseEntity;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.repository.ArchiveCrossInfoRepository;
import kd.bos.archive.repository.ArchiveDatabaseRepository;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.archive.repository.ArchiveReverseRecordRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.ArchiveService;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.id.ID;
import kd.bos.ksql.shell.KDResultSetUnwrapper;
import kd.bos.orm.impl.ORMConfiguration;

final class ArchiveManagerImpl
implements ArchiveManager,
ArchiveLogable {
    protected static final ArchiveManagerImpl INSTANCE = new ArchiveManagerImpl();

    private ArchiveManagerImpl() {
    }

    @Override
    public void notifyTaskPaused(boolean paused, String tableName) {
        ArchiveTaskRuntime.get().fireTaskPaused(paused, tableName);
    }

    @Override
    public boolean checkConfigEnd(long configId) {
        return ArchiveTaskRepository.get().checkLastConfigEnd(configId);
    }

    @Override
    public boolean checkScheduleEnd(long scheduleId) {
        return ArchiveTaskRepository.get().checkLastScheduleEnd(scheduleId);
    }

    @Override
    public List<ArchiveEntityEntity> loadArchiveEntityrcdList() {
        return ArchiveEntityRepository.get().loadArchiveEntityList(null, null);
    }

    @Override
    public List<ArchiveDatabaseEntity> loadESArchiveDatabaseList() {
        return ArchiveDatabaseRepository.get().getDatabaseEntityList(ArchiveRouteType.ES.getKey());
    }

    @Override
    public long addArchiveReverseTask(long entityId, List<Object> billList) {
        ArchiveEntityEntity entityrcdEntity = ArchiveEntityRepository.get().loadArchiveEntity(entityId);
        HashSet<Object> set = new HashSet<Object>(billList);
        billList = new ArrayList<Object>(set);
        long recordId = ID.genLongId();
        String batchnum = ID.longTo36Radix((long)recordId);
        ArchiveReverseRecordRepository.get().insertReverseRecord(recordId, entityrcdEntity.getId(), batchnum, billList.size());
        long taskId = recordId;
        this.insertArchiveReverseMvrcd(taskId, billList);
        ArchiveTaskRepository.get().insertReverseTask(taskId, recordId, batchnum, entityrcdEntity.getId(), entityrcdEntity.getEntitynumber());
        ArchiveService.get().submitChangeTask(entityrcdEntity.getEntitynumber());
        return taskId;
    }

    @Override
    public long addArchiveReverseTask(long entityId) throws Exception {
        ArchiveEntityEntity entityrcdEntity = ArchiveEntityRepository.get().loadArchiveEntity(entityId);
        long recordId = ID.genLongId();
        String batchnum = ID.longTo36Radix((long)recordId);
        LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)entityrcdEntity.getArchiveRoute());
        IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)entityrcdEntity.getEntitynumber(), null);
        String pkField = rootDT.getPrimaryKey().getAlias();
        String mainTable = rootDT.getAlias();
        String logicTable = mainTable + logicArchiveRoute.getLogicSuffix();
        DBRoute archiveRoute = logicArchiveRoute.isCurrentArchive() ? DBRoute.of((String)rootDT.getDBRouteKey()) : DBRoute.of((String)logicArchiveRoute.getRealArchiveKey());
        long taskId = ID.genLongId();
        Object formPK = null;
        long totalSize = 0L;
        while (true) {
            PageRange range = this.queryPageRange(logicTable, pkField, archiveRoute, formPK, 0L);
            if (range.size == 0) break;
            this.insertArchiveReverseMvrcd(taskId, range.pks);
            totalSize += (long)range.size;
            if (range.size != ArchiveConstant.PAGE_SIZE) break;
            formPK = range.toPK;
        }
        ArchiveReverseRecordRepository.get().insertReverseRecord(recordId, entityrcdEntity.getId(), batchnum, totalSize);
        ArchiveTaskRepository.get().insertReverseTask(taskId, recordId, batchnum, entityrcdEntity.getId(), entityrcdEntity.getEntitynumber());
        ArchiveService.get().submitChangeTask(entityrcdEntity.getEntitynumber());
        return taskId;
    }

    @Override
    public void addArchiveReverseTaskByBatchNo(long entityId) throws Exception {
        ArchiveCrossInfoEntity crossInfoEntity = ArchiveCrossInfoRepository.get().loadCrossInfo(entityId);
        if (!crossInfoEntity.getReversestatus().equals("0")) {
            return;
        }
        long recordId = ID.genLongId();
        String batchnum = ID.longTo36Radix((long)recordId);
        long taskId = ID.genLongId();
        Object formPK = null;
        long totalSize = 0L;
        while (true) {
            PageRange range = this.queryPageRange("t_cbs_archi_cross_mvrcd", "fbillid", DBRoute.base, formPK, crossInfoEntity.getTaskid());
            if (range.size == 0) break;
            this.insertArchiveReverseMvrcd(taskId, range.pks);
            totalSize += (long)range.size;
            if (range.size != ArchiveConstant.PAGE_SIZE) break;
            formPK = range.toPK;
        }
        ArchiveReverseRecordRepository.get().insertReverseRecord(recordId, crossInfoEntity.getId(), batchnum, totalSize);
        ArchiveTaskRepository.get().insertReverseTask(taskId, recordId, batchnum, crossInfoEntity.getId(), crossInfoEntity.getEntitynumber());
        ArchiveCrossInfoRepository.get().updateReversestatus(entityId, "1");
    }

    @Override
    public boolean checkTaskEnd(long taskId) {
        return ArchiveTaskRepository.get().checkTaskEnd(taskId);
    }

    private void insertArchiveReverseMvrcd(long taskId, List<Object> billList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into t_cbs_archi_reverse_mvrcd").append("(fid,ftaskid,fbillid) values(?,?,?)");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(billList.size());
        for (Object billid : billList) {
            Object[] param = new Object[]{ID.genLongId(), taskId, billid};
            paramList.add(param);
            if (paramList.size() <= 1000) continue;
            DB.executeBatch((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramList);
            paramList.clear();
        }
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramList);
            paramList.clear();
        }
    }

    private PageRange queryPageRange(String mainTable, String pkField, DBRoute archiRoute, Object fromPK, long taskid) throws Exception {
        StringBuilder sql = new StringBuilder(128);
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        sql.append("select top ").append(ArchiveConstant.PAGE_SIZE).append(" ").append(pkField).append(" from ").append(mainTable);
        if (fromPK != null) {
            sql.append(" where ").append(pkField).append(">?");
            paramList.add(fromPK);
        }
        if (taskid > 0L) {
            if (fromPK != null) {
                sql.append(" and ftaskid = ? ");
            } else {
                sql.append(" where ftaskid = ? ");
            }
            paramList.add(taskid);
        }
        sql.append(" order by ").append(pkField);
        String s = ArchiveUtil.wrapSQL(sql.toString(), false, true);
        return (PageRange)DB.query((DBRoute)archiRoute, (String)s, (Object[])paramList.toArray(), rs -> {
            rs = rs.unwrap(KDResultSetUnwrapper.class).get().getInternalResultSet();
            PageRange range = new PageRange();
            range.pks = new ArrayList<Object>(ArchiveConstant.PAGE_SIZE);
            int size = 0;
            Object last = range.fromPK;
            while (rs.next()) {
                Object temp = rs.getObject(1);
                if (size == 0) {
                    range.fromPK = temp;
                }
                last = temp;
                range.pks.add(temp);
                ++size;
            }
            range.toPK = last;
            range.size = size;
            return range;
        });
    }

    static class PageRange {
        public Object fromPK;
        public List<Object> pks;
        public List<Object[]> fieldValuesList;
        public Object toPK;
        public int size;

        PageRange() {
        }
    }
}

