/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.taskpaused.ArchiveTaskPausedNotifier;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ArchiveTaskRuntime {
    private static final Log log = LogFactory.getLog(ArchiveTaskRuntime.class);
    private static final Map<String, ArchiveTaskRuntime> instanceMap = new ConcurrentHashMap<String, ArchiveTaskRuntime>();
    private final String accountId;
    private final String tenantId;
    private final Map<String, Boolean> pausedMap = new ConcurrentHashMap<String, Boolean>();

    public static ArchiveTaskRuntime get() {
        RequestContextInfo rci = RequestContextInfo.get();
        String accountId = rci.getAccountId();
        return instanceMap.computeIfAbsent(accountId, key -> new ArchiveTaskRuntime((String)key, rci.getTenantId()));
    }

    private ArchiveTaskRuntime(String accountId, String tenantId) {
        this.accountId = accountId;
        this.tenantId = tenantId;
    }

    public void fireTaskPaused(boolean paused, String tableName) {
        this.setTaskPausedCurrentNode(paused, tableName);
        ArchiveTaskPausedNotifier.fireTaskPaused(tableName.toLowerCase(), paused);
    }

    public String setTaskPausedCurrentNode(boolean paused, String tableName) {
        this.pausedMap.put(tableName.toLowerCase(), paused);
        ArchiveUtil.logInfo("setTablePaused " + tableName + " paused=" + paused);
        return tableName;
    }

    public boolean isTaskPaused(String tableName) {
        if (this.pausedMap.isEmpty()) {
            return false;
        }
        if (tableName != null) {
            Boolean isPaused = this.pausedMap.get(tableName.toLowerCase());
            return null == isPaused ? false : isPaused;
        }
        return false;
    }

    public String toString() {
        return "tenantId=" + this.tenantId + ", accountId=" + this.accountId;
    }

    static {
        ArchiveTaskPausedNotifier.registTaskPausedListener(ti -> {
            try (AutoCloseable ac = new RequestContextInfo(ti.getTenantId(), ti.getAccountId()).setupThreadRequestContext();){
                ArchiveTaskRuntime.get().setTaskPausedCurrentNode(ti.isPaused(), ti.getTableName());
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap(e);
            }
        });
    }
}

