/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api;

public class TwoSymbolSequence {
    private static final char[] chars;
    private static final int radix;
    private static final int[] values;

    public static String toString(long v) {
        return TwoSymbolSequence.toString(v, true);
    }

    private static String toString(long v, boolean toValidate) {
        if (toValidate) {
            v = TwoSymbolSequence.getValidatedLong(v);
        }
        StringBuilder sb = new StringBuilder(2);
        do {
            sb.append(chars[(int)(v % (long)radix)]);
        } while ((v /= (long)radix) != 0L);
        return sb.reverse().toString();
    }

    public static String next(String curSeq) {
        return TwoSymbolSequence.toString(TwoSymbolSequence.toLong(curSeq) + 1L, false);
    }

    private static long getValidatedLong(long v) {
        if (TwoSymbolSequence.toLong("ai") <= (v += 370L)) {
            ++v;
        }
        if (TwoSymbolSequence.toLong("am") <= v) {
            ++v;
        }
        if (TwoSymbolSequence.toLong("pk") <= v) {
            ++v;
        }
        if (0L <= v && v < 370L || v > 1295L) {
            throw new UnsupportedOperationException("Over head zz symbol sequence.");
        }
        return v;
    }

    private static long toLong(String seq) {
        try {
            long v = 0L;
            for (char ch : seq.toCharArray()) {
                int vch = values[ch];
                if (vch == -1) {
                    throw new IllegalArgumentException("Sequence " + seq + " has unrecognized character: " + ch);
                }
                v = v * (long)radix + (long)vch;
            }
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Sequence " + seq + " has unrecognized character", e);
        }
    }

    static {
        int i;
        chars = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
        radix = chars.length;
        values = new int[chars[radix - 1] + '\u0001'];
        for (i = 0; i < chars[radix - 1]; ++i) {
            TwoSymbolSequence.values[i] = -1;
        }
        i = 0;
        for (char ch : chars) {
            TwoSymbolSequence.values[ch] = i++;
        }
    }
}

