/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.archive.api.ArchiveApiConstant;
import kd.bos.archive.api.TwoSymbolSequence;
import kd.bos.archive.api.dto.ArchiveDatabase;
import kd.bos.archive.api.service.ArchiveDatabaseApi;
import kd.bos.archive.api.util.ArchiveDatabaseUtils;
import kd.bos.archive.api.util.ArchiveGroupService;
import kd.bos.archive.api.util.EntityCoreInvokeUtils;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.dlock.DLock;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ArchiveDatabaseApiImpl
implements ArchiveDatabaseApi,
ArchiveApiConstant {
    public static final Object dataEntityType;
    private static final ArchiveGroupService archiveGroupService;
    private static final ORM orm;
    private final DynamicObject groupRule = archiveGroupService.initAndGetGroupRule();
    private static final ArchiveDatabaseApiImpl INSTANCE;

    @Override
    public ArchiveDatabase add(String name, String databaseKey) {
        return this.add(new LocaleString(name), databaseKey);
    }

    @Override
    public ArchiveDatabase add(LocaleString name, String databaseKey) {
        return this.add0(name, databaseKey, this.groupRule);
    }

    @Override
    public ArchiveDatabase add(String name, String databaseKey, String groupNumber) {
        return this.add(new LocaleString(name), databaseKey, groupNumber);
    }

    @Override
    public ArchiveDatabase add(LocaleString name, String databaseKey, String groupNumber) {
        QFilter[] qFilters = new QFilter("number", "=", (Object)groupNumber).toArray();
        DynamicObject group = ORM.create().queryOne("bos_cbs_archi_group_rule", qFilters);
        group = Objects.isNull(group) ? this.groupRule : group;
        return this.add0(name, databaseKey, group);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArchiveDatabase add0(LocaleString name, String databaseKey, DynamicObject group) {
        if (!ArchiveDatabaseUtils.isArchiveRoute(databaseKey)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Archive route does not exist.", (String)"ArchiveDatabaseApiImpl_0", (String)"bos-archive", (Object[])new Object[0]));
        }
        try (DLock dLock = DLock.create((String)"ArchiveDatabaseApiImpl#add");){
            if (dLock.tryLock(120000L)) {
                long id = ID.genLongId();
                long userId = RequestContext.get().getCurrUserId();
                String logicSuffix = this.getLogicSuffix(databaseKey);
                DynamicObject databaseObject = orm.newDynamicObject("bos_cbs_archi_database");
                databaseObject.set("id", (Object)id);
                databaseObject.set("masterid", (Object)id);
                databaseObject.set("number", (Object)(databaseKey + "_" + logicSuffix).toUpperCase());
                databaseObject.set("name", (Object)name);
                databaseObject.set("database_type", (Object)ArchiveRouteType.DB.getKey());
                databaseObject.set("database", (Object)databaseKey);
                databaseObject.set("group", (Object)group);
                databaseObject.set("archiveroute", (Object)(databaseKey + '$' + logicSuffix));
                databaseObject.set("logicsuffix", (Object)('$' + logicSuffix));
                databaseObject.set("status", (Object)"C");
                databaseObject.set("enable", (Object)"1");
                databaseObject.set("creator", (Object)userId);
                databaseObject.set("modifier", (Object)userId);
                EntityCoreInvokeUtils.businessDataWriter_save.invoke(null, dataEntityType, new Object[]{databaseObject});
                DynamicObject queryObj = this.findDynamicObjectById(id);
                ArchiveDatabase archiveDatabase = this.convert2Pojo(queryObj);
                return archiveDatabase;
            }
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Failed to acquire distributed lock.", (String)"ArchiveDatabaseApiImpl_1", (String)"bos-archive", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public List<ArchiveDatabase> findAll() {
        DynamicObjectCollection queryCol = Optional.ofNullable(orm.query("bos_cbs_archi_database", null)).orElseGet(DynamicObjectCollection::new);
        Object[] pkList = queryCol.stream().map(DataEntityBase::getPkValue).toArray();
        try {
            DynamicObject[] queryObjs = (DynamicObject[])EntityCoreInvokeUtils.businessDataReader_load.invoke(null, pkList, dataEntityType, Boolean.TRUE);
            return Arrays.stream(queryObjs).map(this::convert2Pojo).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public ArchiveDatabase find(long id) {
        return this.convert2Pojo(this.findDynamicObjectById(id));
    }

    @Override
    public void delete(long id) {
        int count = orm.count("ArchiveDatabaseApiImpl#delete", "bos_cbs_archi_config", new QFilter("group", "=", (Object)id).toArray());
        if (count > 0) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot delete as it is referenced by an archiving rule.", (String)"ArchiveDatabaseApiImpl_4", (String)"bos-archive", (Object[])new Object[0]));
        }
        ArchiveDatabase archiveDatabase = this.find(id);
        if (ArchiveDatabaseUtils.hasArchiveData(archiveDatabase.getArchiveRouteKey())) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot delete as archive data exists.", (String)"ArchiveDatabaseApiImpl_2", (String)"bos-archive", (Object[])new Object[0]));
        }
        try {
            EntityCoreInvokeUtils.businessDataWriter_delete.invoke(null, dataEntityType, new Object[]{id});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void updateName(long id, String name) {
        this.updateName(id, new LocaleString(name));
    }

    @Override
    public void updateName(long id, LocaleString name) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        queryObj.set("name", (Object)name);
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{queryObj});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private DynamicObject findDynamicObjectById(long id) {
        try {
            return (DynamicObject)EntityCoreInvokeUtils.businessDataReader_loadSingle.invoke(null, id, dataEntityType);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private ArchiveDatabase convert2Pojo(DynamicObject dynamicObject) {
        DynamicObject group = dynamicObject.getDynamicObject("group");
        String localeValue = dynamicObject.getLocaleString("name").getLocaleValue();
        if (StringUtils.isEmpty((String)localeValue)) {
            localeValue = (String)dynamicObject.getLocaleString("name").getItem("GLang");
        }
        ArchiveDatabase ret = new ArchiveDatabase();
        ret.setId(dynamicObject.getLong("id"));
        ret.setNumber(dynamicObject.getString("number"));
        ret.setName(localeValue);
        ret.setArchiveRouteKey(dynamicObject.getString("archiveroute"));
        ret.setDatabase(dynamicObject.getString("database"));
        ret.setLogicSuffix(dynamicObject.getString("logicsuffix"));
        ret.setGroupId(Objects.isNull(group) ? 0L : (Long)group.getPkValue());
        ret.setStatus(dynamicObject.getString("status"));
        ret.setEnable(dynamicObject.getString("enable"));
        ret.setMasterId(dynamicObject.getLong("masterid"));
        return ret;
    }

    private String getLogicSuffix(String databaseKey) {
        QFilter qf = new QFilter("archiveroute", "like", (Object)(databaseKey + "%"));
        int count = orm.count("ArchiveDatabaseApiImpl", "bos_cbs_archi_database", qf.toArray());
        String logicSuffix = TwoSymbolSequence.toString(count);
        while (this.existArchiveRoute(databaseKey + '$' + logicSuffix)) {
            logicSuffix = TwoSymbolSequence.next(logicSuffix);
        }
        return logicSuffix;
    }

    private boolean existArchiveRoute(String archiveRouteKey) {
        return orm.exists("bos_cbs_archi_database", new QFilter("archiveroute", "=", (Object)archiveRouteKey).toArray());
    }

    private ArchiveDatabaseApiImpl() {
    }

    public static ArchiveDatabaseApiImpl get() {
        if (!ArchiveDatabaseUtils.existsDBArchiveRoute()) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Please configure the archive database in MC first.", (String)"ArchiveDatabaseApiImpl_3", (String)"bos-archive", (Object[])new Object[0]));
        }
        return INSTANCE;
    }

    static {
        try {
            dataEntityType = EntityCoreInvokeUtils.getDataEntityType.invoke(null, "bos_cbs_archi_database");
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        archiveGroupService = new ArchiveGroupService();
        orm = ORM.create();
        INSTANCE = new ArchiveDatabaseApiImpl();
    }
}

