/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.api.ArchiveApiConstant;
import kd.bos.archive.api.dto.ScheduleResultInfo;
import kd.bos.archive.api.dto.TaskResultInfo;
import kd.bos.archive.api.service.ArchiveResultApi;
import kd.bos.archive.entity.ArchiveCrossInfoEntity;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.repository.ArchiveCrossInfoRepository;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class ArchiveResultApiImpl
implements ArchiveResultApi,
ArchiveApiConstant {
    private static final Log logger = LogFactory.getLog(ArchiveResultApiImpl.class);
    private static final ArchiveResultApiImpl INSTANCE = new ArchiveResultApiImpl();

    public static ArchiveResultApi get() {
        return INSTANCE;
    }

    @Override
    public long count(String entityName, String archiveRoute, Date startTime) {
        return ArchiveCrossInfoRepository.get().count(entityName, archiveRoute, startTime);
    }

    @Override
    public List<ScheduleResultInfo> findScheduleResultInfo(List<Long> scheduleIdList) {
        ArrayList<ScheduleResultInfo> scheduleResultInfoList = new ArrayList<ScheduleResultInfo>(10);
        for (Long scheduleId : scheduleIdList) {
            if (Objects.isNull(scheduleId)) continue;
            List<TaskResultInfo> taskInfoList = this.getTaskResultInfos(scheduleId);
            ScheduleResultInfo scheduleResultInfo = new ScheduleResultInfo();
            scheduleResultInfo.setScheduleId(scheduleId);
            scheduleResultInfo.setTaskResultInfoList(taskInfoList);
            scheduleResultInfoList.add(scheduleResultInfo);
        }
        return scheduleResultInfoList;
    }

    @Override
    public long reverse(String entityNumber, String archiveRoute, List<Object> pkList) {
        long entityId = this.findEntityId(entityNumber, archiveRoute);
        if (entityId == 0L) {
            ArchiveUtil.logInfo(ResManager.loadKDString((String)"[ %1$s ] There is no data in the archive repository [ %2$s ].", (String)"ArchiveResultApiImpl_0", (String)"bos-archive", (Object[])new Object[]{entityNumber, archiveRoute}));
            return 0L;
        }
        return ArchiveManager.get().addArchiveReverseTask(entityId, pkList);
    }

    private long findEntityId(String entityNumber, String archiveRoute) {
        ArchiveEntityEntity archiveEntityEntity = ArchiveEntityRepository.get().loadArchiveEntity(entityNumber, archiveRoute);
        return Objects.isNull(archiveEntityEntity) ? 0L : archiveEntityEntity.getId();
    }

    @NotNull
    private List<TaskResultInfo> getTaskResultInfos(Long scheduleId) {
        List<ArchiveTaskEntity> archiveTaskEntities = ArchiveTaskRepository.get().loadTaskList(scheduleId);
        Optional<ArchiveTaskEntity> rootTaskOptional = this.findRootTask(archiveTaskEntities);
        String rootEntityNumber = rootTaskOptional.isPresent() ? rootTaskOptional.get().getEntitynumber() : "";
        return archiveTaskEntities.stream().map(archiveTaskEntity -> this.toTaskResultInfo((ArchiveTaskEntity)archiveTaskEntity, rootEntityNumber)).collect(Collectors.toList());
    }

    private Optional<ArchiveTaskEntity> findRootTask(List<ArchiveTaskEntity> archiveTaskEntities) {
        return archiveTaskEntities.stream().filter(archiveTaskEntity -> archiveTaskEntity.getId() == archiveTaskEntity.getRootid()).findFirst();
    }

    private TaskResultInfo toTaskResultInfo(ArchiveTaskEntity archiveTaskEntity, String rootEntityNumber) {
        TaskResultInfo taskResultInfo = new TaskResultInfo();
        taskResultInfo.setTaskId(archiveTaskEntity.getId());
        taskResultInfo.setResult(archiveTaskEntity.getTaskstatus().toString());
        taskResultInfo.setEntityName(archiveTaskEntity.getEntitynumber());
        taskResultInfo.setRootEntityName(rootEntityNumber);
        taskResultInfo.setScheduleRcdId(archiveTaskEntity.getSchedulercdid());
        taskResultInfo.setCount(archiveTaskEntity.getTotalcount());
        ArchiveCrossInfoEntity archiveCrossInfoEntity = ArchiveCrossInfoRepository.get().loadCrossInfoByTaskId(archiveTaskEntity.getId());
        if (Objects.nonNull(archiveCrossInfoEntity)) {
            taskResultInfo.setArchiveRoute(archiveCrossInfoEntity.getArchiveRoute());
        }
        return taskResultInfo;
    }
}

