/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api.service.impl;

import java.util.List;
import kd.bos.archive.api.service.ArchiveRouteApi;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ArchiveRouteApiImpl
implements ArchiveRouteApi {
    private static final Log logger = LogFactory.getLog(ArchiveRouteApiImpl.class);
    private static final ArchiveRouteApiImpl INSTANCE = new ArchiveRouteApiImpl();

    public static ArchiveRouteApiImpl get() {
        return INSTANCE;
    }

    @Override
    public void syncArchiveRoute(String srcEntityNumber, String toEntityNumber) {
        List<ArchiveEntityEntity> entityList = ArchiveEntityRepository.get().loadArchiveEntityList(srcEntityNumber);
        ArchiveEntityRepository.get().deleteArchiveRoute(toEntityNumber);
        if (!entityList.isEmpty()) {
            for (ArchiveEntityEntity entity : entityList) {
                ArchiveEntityRepository.get().insertEntity(toEntityNumber, entity.getArchiveRoute(), 0L, entity.getRouteType());
            }
        }
        DBArchiveManager.get().notifyReloadArchiveConfig(toEntityNumber);
    }
}

