/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.api.ArchiveApiConstant;
import kd.bos.archive.api.dto.ArchiveBasedata;
import kd.bos.archive.api.dto.ArchiveDatabase;
import kd.bos.archive.api.dto.ArchiveRule;
import kd.bos.archive.api.factory.ArchiveApiFactory;
import kd.bos.archive.api.service.ArchiveRuleApi;
import kd.bos.archive.api.util.EntityCoreInvokeUtils;
import kd.bos.archive.entity.ArchiveBillSetEntity;
import kd.bos.archive.entity.ArchiveConfigRefbdEntity;
import kd.bos.archive.enums.ArchiveConfigFilterTypeEnum;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.framework.plugin.ArchivePlugin;
import kd.bos.archive.repository.ArchiveBillSetRepository;
import kd.bos.archive.repository.ArchiveConfigRefbdRepository;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.archive.RouteInfo;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ArchiveRuleApiImpl
implements ArchiveRuleApi,
ArchiveApiConstant {
    private static final ORM orm = ORM.create();
    public static final Object dataEntityType;
    private static final ArchiveRuleApiImpl INSTANCE;

    @Override
    public ArchiveRule addByCustom(String entityNumber, ArchiveDatabase archiveDatabase, String customPluginClass) {
        DynamicObject billSet = this.validateEntityAndRetBillSet(entityNumber);
        this.assertArchiveDatabaseCanUse(entityNumber, archiveDatabase);
        DynamicObject ruleConfig = orm.newDynamicObject("bos_cbs_archi_config");
        return this.saveRuleConfig(ArchiveConfigFilterTypeEnum.CUSTOM, billSet, ruleConfig, entityNumber, archiveDatabase, null, customPluginClass);
    }

    @Override
    public ArchiveRule addByBill(String entityNumber, ArchiveDatabase archiveDatabase, String filterCondition) {
        DynamicObject billSet = this.validateEntityAndRetBillSet(entityNumber);
        this.assertArchiveDatabaseCanUse(entityNumber, archiveDatabase);
        DynamicObject ruleConfig = orm.newDynamicObject("bos_cbs_archi_config");
        return this.saveRuleConfig(ArchiveConfigFilterTypeEnum.BILL, billSet, ruleConfig, entityNumber, archiveDatabase, filterCondition, null);
    }

    @Override
    public List<ArchiveRule> findAll() {
        QFilter movingTypeFilter = new QFilter("movingtype", "=", (Object)ArchiveConfigMovingTypeEnum.ARCHIVE.getKey());
        DynamicObjectCollection queryCol = orm.query("bos_cbs_archi_config", movingTypeFilter.toArray());
        queryCol = Optional.ofNullable(queryCol).orElseGet(DynamicObjectCollection::new);
        Object[] pkList = queryCol.stream().map(DataEntityBase::getPkValue).toArray();
        try {
            DynamicObject[] queryObjs = (DynamicObject[])EntityCoreInvokeUtils.businessDataReader_load.invoke(null, pkList, dataEntityType, Boolean.TRUE);
            return Arrays.stream(queryObjs).map(this::convert2Pojo).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public ArchiveRule find(long id) {
        return this.convert2Pojo(this.findDynamicObjectById(id));
    }

    @Override
    public void updateByCustom(long id, ArchiveDatabase archiveDatabase, String customPluginClass) {
        this.updateRule0(id, ArchiveConfigFilterTypeEnum.CUSTOM, archiveDatabase, null, customPluginClass);
    }

    @Override
    public void updateByCustom(long id, String customPluginClass) {
        this.updateCondition0(id, ArchiveConfigFilterTypeEnum.CUSTOM, null, customPluginClass);
    }

    @Override
    public void updateByBill(long id, ArchiveDatabase archiveDatabase, String filterCondition) {
        this.updateRule0(id, ArchiveConfigFilterTypeEnum.BILL, archiveDatabase, filterCondition, null);
    }

    @Override
    public void updateByBill(long id, String filterCondition) {
        this.updateCondition0(id, ArchiveConfigFilterTypeEnum.BILL, filterCondition, null);
    }

    private void updateRule0(long id, ArchiveConfigFilterTypeEnum filterTypeEnum, ArchiveDatabase archiveDatabase, String filterCondition, String customPluginClass) {
        DynamicObject ruleConfig = this.findDynamicObjectById(id);
        this.assertCanEdit(ruleConfig);
        String entityNumber = ruleConfig.getString("entitynumber");
        DynamicObject billSet = this.validateEntityAndRetBillSet(entityNumber);
        this.assertArchiveDatabaseCanUse(entityNumber, archiveDatabase);
        this.saveRuleConfig(filterTypeEnum, billSet, ruleConfig, entityNumber, archiveDatabase, filterCondition, customPluginClass);
    }

    private void updateCondition0(long id, ArchiveConfigFilterTypeEnum filterTypeEnum, String filterCondition, String customPluginClass) {
        DynamicObject ruleConfig = this.findDynamicObjectById(id);
        this.assertCanEdit(ruleConfig);
        String entityNumber = ruleConfig.getString("entitynumber");
        long databaseID = ruleConfig.getDynamicObject("group").getLong("id");
        ArchiveDatabase archiveDatabase = ArchiveApiFactory.getArchiveDatabaseApi().find(databaseID);
        DynamicObject billSet = this.validateEntityAndRetBillSet(entityNumber);
        this.saveRuleConfig(filterTypeEnum, billSet, ruleConfig, entityNumber, archiveDatabase, filterCondition, customPluginClass);
    }

    @Override
    public void updateArchiveDatabase(long id, ArchiveDatabase archiveDatabase) {
        DynamicObject ruleConfig = this.findDynamicObjectById(id);
        this.assertCanEdit(ruleConfig);
        ruleConfig.set("group", (Object)archiveDatabase.getId());
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{ruleConfig});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void enable(long id) {
        DynamicObject ruleConfig = this.findDynamicObjectById(id);
        DynamicObject group = ruleConfig.getDynamicObject("group");
        if (Objects.isNull(group)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Enable failed, no archive database configured.", (String)"ArchiveRuleApiImpl_11", (String)"bos-archive", (Object[])new Object[0]));
        }
        ruleConfig.set("enable", (Object)"1");
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{ruleConfig});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void disable(long id) {
        if (!ArchiveManager.get().checkConfigEnd(id)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot perform action as the configuration is being run by a schedule task.", (String)"ArchiveRuleApiImpl_14", (String)"bos-archive", (Object[])new Object[0]));
        }
        DynamicObject ruleConfig = this.findDynamicObjectById(id);
        ruleConfig.set("enable", (Object)"0");
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{ruleConfig});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void delete(long id) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        this.assertCanEdit(queryObj);
        String sql = "select count(*) from t_cbs_archi_scheduleentry where fconfigid = ?";
        boolean hasRef = (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{id}, rs -> rs.next() && rs.getLong(1) > 0L);
        if (hasRef) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot delete as it is referenced by an archiving schedule.", (String)"ArchiveRuleApiImpl_12", (String)"bos-archive", (Object[])new Object[0]));
        }
        try {
            EntityCoreInvokeUtils.businessDataWriter_delete.invoke(null, dataEntityType, new Object[]{id});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void addBasedata(long id, ArchiveBasedata basedata) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        this.assertCanEdit(queryObj);
        String number = basedata.getNumber();
        String name = ArchiveUtil.getDisplayName(number);
        if (this.existsBasedata(id, number)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The basic data already exists, please do not add it again.", (String)"ArchiveRuleApiImpl_0", (String)"bos-archive", (Object[])new Object[0]));
        }
        int maxSeq = ArchiveConfigRefbdRepository.get().getMaxSeq(id, number);
        Object[] params = new Object[]{id, ID.genLongId(), ++maxSeq, number, name, number, "1", basedata.getTimeAttr()};
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        paramsList.add(params);
        ArchiveConfigRefbdRepository.get().insertLackedNum(paramsList);
    }

    @Override
    public void deleteBasedata(long id, String bdNumber) {
        ArchiveConfigRefbdRepository.get().deleteBasedata(id, bdNumber, false);
    }

    @Override
    public void updateBasedata(long id, ArchiveBasedata basedata) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        this.assertCanEdit(queryObj);
        String number = basedata.getNumber();
        if (!this.existsBasedata(id, number)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The basic data does not exist.", (String)"ArchiveRuleApiImpl_13", (String)"bos-archive", (Object[])new Object[0]));
        }
        ArchiveConfigRefbdRepository.get().updateTimeAttr(id, number, basedata.getTimeAttr());
    }

    @Override
    public boolean existsBasedata(long id, String number) {
        return ArchiveConfigRefbdRepository.get().existBasedata(id, number);
    }

    @Override
    public List<ArchiveBasedata> findAllBasedata(long id) {
        List<ArchiveConfigRefbdEntity> archiveConfigRefbdEntities = ArchiveConfigRefbdRepository.get().loadConfigRefbdList(id);
        return archiveConfigRefbdEntities.stream().map(entity -> new ArchiveBasedata(entity.getBdnumber(), entity.getTimeAttr())).collect(Collectors.toList());
    }

    private void assertCanEdit(DynamicObject queryObj) {
        String enable = queryObj.getString("enable");
        if (Objects.equals(enable, "1")) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot perform action on enabled data.", (String)"ArchiveRuleApiImpl_1", (String)"bos-archive", (Object[])new Object[0]));
        }
    }

    private ArchiveRule saveRuleConfig(ArchiveConfigFilterTypeEnum filterTypeEnum, DynamicObject billSet, DynamicObject ruleConfig, String entityNumber, ArchiveDatabase archiveDatabase, String filter, String customPluginClass) {
        Date now;
        String condition;
        JSONObject jsonObject;
        HashMap<String, String> map;
        long id = ID.genLongId();
        String filterType = filterTypeEnum.getKey();
        RequestContext rc = RequestContext.get();
        long userId = rc.getCurrUserId();
        if (userId == 0L) {
            rc.setUserId("0");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            map = new HashMap<String, String>(2);
            map.put(filterType, filter);
            ruleConfig.set("conditiondesc", (Object)ArchiveUtil.parse2QFilter(entityNumber, filter).toString());
            jsonObject = new JSONObject(map);
            condition = jsonObject.toString();
        } else if (customPluginClass != null) {
            map = new HashMap(2);
            try {
                Class<ArchivePlugin> archivePluginClazz = Class.forName(customPluginClass);
                if (!ArchivePlugin.class.isAssignableFrom(archivePluginClazz) || archivePluginClazz.isAssignableFrom(ArchivePlugin.class)) {
                    throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Plugin Class Please Implement Kd.bos.archive.framework.plugin.ArchivePlugin interface.", (String)"ArchiveRuleApiImpl_2", (String)"bos-archive", (Object[])new Object[0]));
                }
                archivePluginClazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Plug-In class %s does not exist.", (String)"ArchiveRuleApiImpl_3", (String)"bos-archive", (Object[])new Object[]{customPluginClass}), e);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The no-argument constructor of plugin class %s must use the public access modifier.", (String)"ArchiveRuleApiImpl_4", (String)"bos-archive", (Object[])new Object[]{customPluginClass}), e);
            }
            catch (InstantiationException e) {
                throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Plug-In class %s instantiation exception, please check.", (String)"ArchiveRuleApiImpl_5", (String)"bos-archive", (Object[])new Object[]{customPluginClass}), e);
            }
            map.put(filterType, customPluginClass);
            jsonObject = new JSONObject(map);
            condition = jsonObject.toString();
            ruleConfig.set("conditiondesc", (Object)condition);
        } else {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The Parameters filterCondition and customPluginClass cannot be null at the same time.", (String)"ArchiveRuleApiImpl_6", (String)"bos-archive", (Object[])new Object[0]));
        }
        if (ruleConfig.getLong("id") == 0L) {
            ruleConfig.set("id", (Object)id);
            ruleConfig.set("masterid", (Object)id);
            ruleConfig.set("billset", billSet.getPkValue());
            ruleConfig.set("entitynumber", (Object)entityNumber);
            ruleConfig.set("number", (Object)entityNumber);
            ruleConfig.set("name", (Object)billSet.getLocaleString("name"));
            ruleConfig.set("filtertype", (Object)filterType);
            ruleConfig.set("movingtype", (Object)"0");
            ruleConfig.set("conditiontype", (Object)"0");
            ruleConfig.set("condition", (Object)condition);
            ruleConfig.set("syncbasedata", (Object)true);
            ruleConfig.set("enable", (Object)"0");
            ruleConfig.set("status", (Object)"C");
            ruleConfig.set("group", (Object)archiveDatabase.getId());
            now = new Date();
            ruleConfig.set("creator", (Object)userId);
            ruleConfig.set("createtime", (Object)now);
            ruleConfig.set("modifier", (Object)userId);
            ruleConfig.set("modifytime", (Object)now);
            this.buildBDEntry(entityNumber, ruleConfig);
            try {
                EntityCoreInvokeUtils.businessDataWriter_save.invoke(null, dataEntityType, new Object[]{ruleConfig});
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        ruleConfig.set("filtertype", (Object)filterType);
        ruleConfig.set("condition", (Object)condition);
        ruleConfig.set("group", (Object)archiveDatabase.getId());
        now = new Date();
        ruleConfig.set("modifier", (Object)userId);
        ruleConfig.set("modifytime", (Object)now);
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{ruleConfig});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        DynamicObject queryObj = this.findDynamicObjectById(ruleConfig.getLong("id"));
        return this.convert2Pojo(queryObj);
    }

    private DynamicObject findDynamicObjectById(long id) {
        try {
            return (DynamicObject)EntityCoreInvokeUtils.businessDataReader_loadSingle.invoke(null, id, dataEntityType);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private ArchiveRule convert2Pojo(DynamicObject save) {
        DynamicObject billSet = save.getDynamicObject("billset");
        DynamicObject group = save.getDynamicObject("group");
        String localeValue = save.getLocaleString("name").getLocaleValue();
        if (StringUtils.isEmpty((String)localeValue)) {
            localeValue = (String)save.getLocaleString("name").getItem("GLang");
        }
        if (StringUtils.isEmpty((String)localeValue)) {
            localeValue = save.getLocaleString("name").getLocaleValue_zh_CN();
        }
        ArchiveRule archiveRule = new ArchiveRule();
        archiveRule.setId((Long)save.getPkValue());
        archiveRule.setNumber(save.getString("number"));
        archiveRule.setName(localeValue);
        archiveRule.setBillSetId(Objects.isNull(billSet) ? 0L : (Long)billSet.getPkValue());
        archiveRule.setGroupId(Objects.isNull(group) ? 0L : (Long)group.getPkValue());
        archiveRule.setFilterType(ArchiveConfigFilterTypeEnum.from(save.getString("filtertype")));
        archiveRule.setConditionDesc(save.getString("conditiondesc"));
        archiveRule.setEnable(save.getString("enable"));
        archiveRule.setMark(save.getString("remark"));
        archiveRule.setMovingType(ArchiveConfigMovingTypeEnum.from(save.getString("movingtype")));
        archiveRule.setSyncBaseData(save.getString("syncbasedata"));
        archiveRule.setCondition(save.getString("condition"));
        archiveRule.setStatus(save.getString("status"));
        archiveRule.setMasterId((Long)save.getPkValue());
        archiveRule.setEntityNumber(save.getString("entitynumber"));
        return archiveRule;
    }

    private DynamicObject validateEntityAndRetBillSet(String entityNumber) {
        DynamicObject billSet = orm.queryOne("bos_cbs_archi_billset", new QFilter("entitynumber", "=", (Object)entityNumber).toArray());
        ArchiveBillSetEntity archiveBillSetEntity = ArchiveBillSetRepository.get().loadBillSetEntity(entityNumber);
        if (Objects.isNull(archiveBillSetEntity)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot archive Document %s.", (String)"ArchiveRuleApiImpl_7", (String)"bos-archive", (Object[])new Object[]{entityNumber}));
        }
        if (ArchiveUtil.isCascadeChildBill(entityNumber)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The document[%s] is a cascading sub- document. The archiving of the cascading sub- document depends on the base document, and the filing rules cannot be configured separately.", (String)"ArchiveRuleApiImpl_8", (String)"bos-archive", (Object[])new Object[]{entityNumber}));
        }
        try {
            Object billSetDataType = EntityCoreInvokeUtils.getDataEntityType.invoke(null, "bos_cbs_archi_billset");
            return (DynamicObject)EntityCoreInvokeUtils.businessDataReader_loadSingle.invoke(null, archiveBillSetEntity.getId(), billSetDataType);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private void assertArchiveDatabaseCanUse(String entityNumber, ArchiveDatabase archiveDatabase) {
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null);
        String routeKey = dt.getDBRouteKey();
        RouteInfo routeInfo = MCArchive.get((String)routeKey);
        if (!routeInfo.hasArchiveRoute()) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"No archive database configured for the application of the form %s.", (String)"ArchiveRuleApiImpl_9", (String)"bos-archive", (Object[])new Object[]{entityNumber}));
        }
        List archiveInfoList = routeInfo.getArchiveInfo();
        LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)archiveDatabase.getDatabase());
        long count = archiveInfoList.stream().filter(archiveInfo -> !routeKey.equals(archiveInfo.getKey())).filter(archiveInfo -> archiveInfo.getKey().equals(logicArchiveRoute.getRealArchiveKey())).count();
        if (count == 0L) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The archive database does not match. Please select the archive database of the application to which the form belongs.", (String)"ArchiveRuleApiImpl_10", (String)"bos-archive", (Object[])new Object[0]));
        }
    }

    private void buildBDEntry(String entityNumber, DynamicObject ruleConfig) {
        DynamicObjectCollection entryEntity = ruleConfig.getDynamicObjectCollection("entryentity");
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        if (ArchiveUtil.isCascadeRootBill(entityNumber)) {
            ArchiveUtil.collectDataEntityType(entityNumber, dataEntityTypes);
        } else {
            IDataEntityType dt2 = orm.getDataEntityType(entityNumber);
            dataEntityTypes.add(dt2);
        }
        HashSet baseSet = new HashSet();
        dataEntityTypes.forEach(dt -> {
            String dbRouteKey = dt.getDBRouteKey();
            DBRoute entityDB = DBRoute.of((String)dbRouteKey);
            ArchiveUtil.collectBaseDataName(dt, baseSet, entityDB);
        });
        baseSet.forEach(number -> {
            DynamicObject entry = orm.newDynamicObject("bos_cbs_archi_config.entryentity");
            entry.set("bd", number);
            entry.set("bdnumber", number);
            entry.set("bdname", (Object)ArchiveUtil.getDisplayName(entityNumber));
            entry.set("custom", (Object)false);
            entryEntity.add((Object)entry);
        });
    }

    private ArchiveRuleApiImpl() {
    }

    public static ArchiveRuleApiImpl get() {
        return INSTANCE;
    }

    static {
        try {
            dataEntityType = EntityCoreInvokeUtils.getDataEntityType.invoke(null, "bos_cbs_archi_config");
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        INSTANCE = new ArchiveRuleApiImpl();
    }
}

