/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api.util;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.archive.api.ArchiveApiConstant;
import kd.bos.archive.api.ArchiveRepeatModeEnum;
import kd.bos.archive.api.dto.ArchivePlan;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;

public class ScheduleApiInvokeUtils
implements ArchiveApiConstant {
    public static Class<?> JobType;
    public static Method JobType_values;
    public static Class<?> JobInfo;
    public static Method JobInfo_setJobType;
    public static Method JobInfo_setTaskClassname;
    public static Method JobInfo_setTaskDefineId;
    public static Method JobInfo_setName;
    public static Method JobInfo_setNumber;
    public static Method JobInfo_setParams;
    public static Class<?> RepeatModeEnum;
    public static Method RepeatModeEnum_values;
    public static Class<?> PlanInfo;
    public static Method PlanInfo_setId;
    public static Method PlanInfo_setName;
    public static Method PlanInfo_setStartTime;
    public static Method PlanInfo_setEndTime;
    public static Method PlanInfo_setRepeatMode;
    public static Method PlanInfo_setPeriod;
    public static Method PlanInfo_setJobId;
    public static Method PlanInfo_setHost;
    public static Method PlanInfo_setNumber;
    public static Class<?> ScheduleServiceHelper;
    public static Method ScheduleServiceHelper_createJob;
    public static Method ScheduleServiceHelper_createPlan;
    public static Class<?> JobDispatcherProxy;
    public static Method JobDispatcherProxy_updatePlan;

    public static Enum getBizJobTypeEnum() {
        try {
            Enum[] enums;
            for (Enum ee : enums = (Enum[])JobType_values.invoke(null, new Object[0])) {
                if (!"BIZ".equals(ee.name())) continue;
                return ee;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        return null;
    }

    public static String createJob(long scheduleId, String jobNumber) {
        try {
            Object jobInfo = JobInfo.newInstance();
            JobInfo_setJobType.invoke(jobInfo, ScheduleApiInvokeUtils.getBizJobTypeEnum());
            JobInfo_setTaskClassname.invoke(jobInfo, "kd.bos.cbs.plugin.archive.task.ArchiveTask");
            JobInfo_setTaskDefineId.invoke(jobInfo, "2145XJVI2N49");
            JobInfo_setName.invoke(jobInfo, ResManager.loadKDString((String)"Archive scheduling background to automatically create jobs", (String)"ScheduleApiInvokeUtils_0", (String)"bos-archive", (Object[])new Object[0]));
            JobInfo_setNumber.invoke(jobInfo, jobNumber);
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("ArchiveSchemaId", scheduleId);
            JobInfo_setParams.invoke(jobInfo, params);
            return (String)ScheduleServiceHelper_createJob.invoke(null, jobInfo);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    public static Enum getRepeatModeEnum(String RepeatModeEnumKey) {
        try {
            Enum[] enums;
            for (Enum ee : enums = (Enum[])RepeatModeEnum_values.invoke(null, new Object[0])) {
                if (!RepeatModeEnumKey.equalsIgnoreCase(ee.name())) continue;
                return ee;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        return null;
    }

    public static String createPlan(ArchivePlan archivePlan, String jobId, String jobNumber) {
        try {
            Object planInfo = PlanInfo.newInstance();
            PlanInfo_setName.invoke(planInfo, ResManager.loadKDString((String)"Archive Schedule Create Schedule", (String)"ScheduleApiInvokeUtils_1", (String)"bos-archive", (Object[])new Object[0]));
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(archivePlan.getStartTime());
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(archivePlan.getEndTime());
            PlanInfo_setStartTime.invoke(planInfo, startCalendar);
            PlanInfo_setEndTime.invoke(planInfo, endCalendar);
            PlanInfo_setRepeatMode.invoke(planInfo, ScheduleApiInvokeUtils.getRepeatModeEnum(archivePlan.getRepeatModeEnum().name()));
            PlanInfo_setPeriod.invoke(planInfo, archivePlan.getPeriod());
            PlanInfo_setJobId.invoke(planInfo, jobId);
            PlanInfo_setNumber.invoke(planInfo, jobNumber + "_SKDP_S");
            return (String)ScheduleServiceHelper_createPlan.invoke(null, planInfo);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private static ArchiveRepeatModeEnum getRepeatMode(String repeatMode) {
        ArchiveRepeatModeEnum repeatModeEnum;
        if ("n".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = ArchiveRepeatModeEnum.NONE;
        } else if ("mi".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = ArchiveRepeatModeEnum.ByMinutes;
        } else if ("h".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = ArchiveRepeatModeEnum.ByHours;
        } else if ("d".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = ArchiveRepeatModeEnum.ByDays;
        } else if ("w".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = ArchiveRepeatModeEnum.ByWeeks;
        } else if ("m".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = ArchiveRepeatModeEnum.ByMonths;
        } else if ("y".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = ArchiveRepeatModeEnum.ByYears;
        } else {
            throw kd.bos.xdb.exception.ExceptionUtil.wrap((String)ResManager.loadKDString((String)"RepeatModeEnum\u4e0d\u5b58\u5728\u8be5\u679a\u4e3e\u503c\uff1a%s", (String)"ArchiveScheduleUtils_1", (String)"bos-archive", (Object[])new Object[]{repeatMode}));
        }
        return repeatModeEnum;
    }

    public static void updatePlan(DynamicObject scheduleObj, ArchivePlan archivePlan) {
        try {
            Object planInfo = PlanInfo.newInstance();
            PlanInfo_setId.invoke(planInfo, scheduleObj.getString("id"));
            PlanInfo_setName.invoke(planInfo, scheduleObj.getString("number"));
            PlanInfo_setNumber.invoke(planInfo, scheduleObj.getString("number"));
            DynamicObject job = scheduleObj.getDynamicObject("job");
            String jobId = Objects.isNull(job) ? "" : job.getString("id");
            PlanInfo_setJobId.invoke(planInfo, jobId);
            PlanInfo_setHost.invoke(planInfo, scheduleObj.getString("txthost"));
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(archivePlan.getStartTime());
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(archivePlan.getEndTime());
            PlanInfo_setStartTime.invoke(planInfo, startCalendar);
            PlanInfo_setEndTime.invoke(planInfo, endCalendar);
            PlanInfo_setRepeatMode.invoke(planInfo, ScheduleApiInvokeUtils.getRepeatModeEnum(archivePlan.getRepeatModeEnum().toString()));
            PlanInfo_setPeriod.invoke(planInfo, archivePlan.getPeriod());
            JobDispatcherProxy_updatePlan.invoke(JobDispatcherProxy.newInstance(), planInfo);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    static {
        try {
            JobType = Class.forName("kd.bos.schedule.api.JobType");
            JobType_values = JobType.getMethod("values", new Class[0]);
            JobInfo = Class.forName("kd.bos.schedule.api.JobInfo");
            JobInfo_setJobType = JobInfo.getMethod("setJobType", JobType);
            JobInfo_setTaskClassname = JobInfo.getMethod("setTaskClassname", String.class);
            JobInfo_setTaskDefineId = JobInfo.getMethod("setTaskDefineId", String.class);
            JobInfo_setName = JobInfo.getMethod("setName", String.class);
            JobInfo_setNumber = JobInfo.getMethod("setNumber", String.class);
            JobInfo_setParams = JobInfo.getMethod("setParams", Map.class);
            RepeatModeEnum = Class.forName("kd.bos.schedule.api.RepeatModeEnum");
            RepeatModeEnum_values = RepeatModeEnum.getMethod("values", new Class[0]);
            PlanInfo = Class.forName("kd.bos.schedule.api.PlanInfo");
            PlanInfo_setId = PlanInfo.getMethod("setId", String.class);
            PlanInfo_setName = PlanInfo.getMethod("setName", String.class);
            PlanInfo_setStartTime = PlanInfo.getMethod("setStartTime", Calendar.class);
            PlanInfo_setEndTime = PlanInfo.getMethod("setEndTime", Calendar.class);
            PlanInfo_setRepeatMode = PlanInfo.getMethod("setRepeatMode", RepeatModeEnum);
            PlanInfo_setPeriod = PlanInfo.getMethod("setPeriod", Integer.TYPE);
            PlanInfo_setJobId = PlanInfo.getMethod("setJobId", String.class);
            PlanInfo_setNumber = PlanInfo.getMethod("setNumber", String.class);
            PlanInfo_setHost = PlanInfo.getMethod("setHost", String.class);
            ScheduleServiceHelper = Class.forName("kd.bos.servicehelper.schedule.ScheduleServiceHelper");
            ScheduleServiceHelper_createJob = ScheduleServiceHelper.getMethod("createJob", JobInfo);
            ScheduleServiceHelper_createPlan = ScheduleServiceHelper.getMethod("createPlan", PlanInfo);
            JobDispatcherProxy = Class.forName("kd.bos.schedule.server.JobDispatcherProxy");
            JobDispatcherProxy_updatePlan = JobDispatcherProxy.getMethod("updatePlan", PlanInfo);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

