/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.changetask;

import kd.bos.archive.changetask.ArchiveChangeTaskInfo;
import kd.bos.archive.changetask.ArchiveChangeTaskListener;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class ArchiveChangeTaskNotifier
extends ZKWatchValueNotifier {
    private static final String ARCHIVE_TASK_CHANGE_WATCHER = "archive.task.change.watcher";
    private static final String FIRE_ARCHIVE_TASK_CHANGE_LOCK_KEY = "/archive/fire_change_task";

    public static void registerChangeTaskListener(final ArchiveChangeTaskListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    ArchiveChangeTaskInfo ai = ArchiveChangeTaskListener.fromKey((String)newValue);
                    l.onReceiveChangeTask(ai);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        ArchiveChangeTaskNotifier.observeChange((String)ARCHIVE_TASK_CHANGE_WATCHER, (ConfigurationChangeListener)listener);
    }

    public static void fireChangeTask(String recordName) {
        String value = ArchiveChangeTaskListener.currentKey(recordName);
        log.info("fireChangeTask " + recordName + " " + value);
        ArchiveChangeTaskNotifier.fireLimit((String)FIRE_ARCHIVE_TASK_CHANGE_LOCK_KEY, (String)ARCHIVE_TASK_CHANGE_WATCHER, (String)value);
    }
}

