/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.config;

import java.util.HashMap;
import java.util.Map;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.config.AccountArchiveConfigInitCallback;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.config.ArchiveParameterValues;
import kd.bos.archive.config.ArchiveParameters;
import kd.bos.archive.util.Accounts;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.db.archive.DBArchiveRuntime;
import kd.bos.instance.Instance;
import kd.bos.thread.ThreadLifeCycleManager;

public class AccountArchiveConfigService
implements ArchiveLogable {
    private static final AccountArchiveConfigService INSTANCE = new AccountArchiveConfigService();
    private AccountArchiveConfigInitCallback initCallback;

    public static AccountArchiveConfigService get() {
        return INSTANCE;
    }

    private AccountArchiveConfigService() {
    }

    public void start(AccountArchiveConfigInitCallback initCallback) {
        this.initCallback = initCallback;
        DBArchiveManager.get().setup();
        this.loadAccountArchiveConfig();
    }

    public void stop() {
    }

    private void loadAccountArchiveConfig() {
        Thread loadThread = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> {
            try {
                for (RequestContext rc : Accounts.getAccountRequestContext()) {
                    RequestContext.copyAndSet((RequestContext)rc);
                    String accountId = rc.getAccountId();
                    try {
                        DBArchiveRuntime.get().loadArchiveConfigs(false);
                        DBArchiveRuntime.get().loadArchiveIndexConfigs(false);
                        ArchiveParameterValues pmap = ArchiveParameters.get();
                        if (pmap == null || pmap.isEmpty()) {
                            Map<String, Object> map = AccountArchiveConfigService.queryParameterFormDB();
                            pmap = ArchiveParameters.setMap(map);
                            if (log.isInfoEnabled()) {
                                StringBuilder msg = new StringBuilder("loadAccountArchiveConfig@queryFromDB@").append(Instance.getInstanceId()).append("->map").append("----\r\n").append(map.toString()).append("\r\n");
                                log.info(msg.toString());
                            }
                        } else if (log.isInfoEnabled()) {
                            StringBuilder msg = new StringBuilder("loadAccountArchiveConfig@queryFromDB@").append(Instance.getInstanceId()).append("->pmap").append("----\r\n").append(pmap.getAll().toString()).append("\r\n");
                            log.info(msg.toString());
                        }
                        boolean archiveEnable = pmap.isEnable();
                        if (archiveEnable) {
                            AccountEnable.getEnableAccountIds().add(accountId);
                            continue;
                        }
                        AccountEnable.getEnableAccountIds().remove(accountId);
                    }
                    catch (Exception e) {
                        log.warn("loadAccountArchiveConfig failed: accountId=" + accountId + ", tenantId=" + rc.getTenantId(), (Throwable)e);
                    }
                }
            }
            finally {
                this.initCallback.onArchiveConfigInited();
            }
        }));
        loadThread.setDaemon(true);
        loadThread.setName("archive-account-archive-config-loader");
        loadThread.start();
    }

    private static Map<String, Object> queryParameterFormDB() {
        Map<String, Object> ret = new HashMap<String, Object>(2);
        String data = (String)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT FDATA FROM T_CBS_ARCHI_PARAM WHERE FTYPE = ?", (Object[])new Object[]{"archive"}, rs -> {
            if (rs.next()) {
                return rs.getString("FDATA");
            }
            return null;
        });
        if (StringUtils.isNotBlank((CharSequence)data)) {
            ret = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        }
        return ret;
    }
}

