/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.config;

import kd.bos.archive.config.AccountArchiveEnableChangedListener;
import kd.bos.archive.config.AccountArchiveInfo;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.util.ConfigurationChangeListener;

public class AccountArchiveEnableChangedNotifier
extends ZKWatchValueNotifier {
    private static final String ARCHIVE_ACCOUNT_ENABLE_WATCHER = "archive.account.enable.watcher";
    private static final String FIRE_RELOAD_ARCHIVE_ACCOUNT_ENABLE_LOCK_KEY = "/archive/fire_reload_archive_account_enable";

    public static void registerReloadArchiveAccountEnableListener(final AccountArchiveEnableChangedListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    AccountArchiveInfo ai = AccountArchiveEnableChangedListener.fromKey((String)newValue);
                    l.onAccountArchiveEnableChanged(ai);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
        };
        AccountArchiveEnableChangedNotifier.observeChange((String)ARCHIVE_ACCOUNT_ENABLE_WATCHER, (ConfigurationChangeListener)listener);
    }

    public static void fireReloadAccountArchiveEnable(boolean enable) {
        String value = AccountArchiveEnableChangedListener.currentKey(enable);
        log.info("fireReloadAccountArchiveEnable " + value);
        AccountArchiveEnableChangedNotifier.fireLimit((String)FIRE_RELOAD_ARCHIVE_ACCOUNT_ENABLE_LOCK_KEY, (String)ARCHIVE_ACCOUNT_ENABLE_WATCHER, (String)value);
    }
}

