/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.framework.demo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.framework.plugin.EntityArchivePlugin;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.junit.Assert;

public class DemoEntityArchivePlugin
implements EntityArchivePlugin {
    static final String entityNumber = "bos_archi_show_1";

    public Iterator<Long> queryEntityIds() {
        ArrayList<Long> list = new ArrayList<Long>();
        try (DataSet ds = ORM.create().queryDataSet("DemoEntityArchivePlugin", entityNumber, this.getPrimaryKey(), this.getQFilters());){
            for (Row d : ds) {
                list.add(d.getLong("fid"));
            }
        }
        Iterator<Long> iterator = list.iterator();
        return iterator;
    }

    @Override
    public void callScheduleInfo(String entityName, long taskId, long scheduleId, String archiveRoute) {
        ArchiveTaskEntity archiveTaskEntity = ArchiveTaskRepository.get().loadTask(taskId);
        Assert.assertTrue((archiveTaskEntity.getTaskstatus() == ArchiveTaskStatusEnum.EXECUTING ? 1 : 0) != 0);
    }

    String getPrimaryKey() {
        return ORM.create().getDataEntityType(entityNumber).getPrimaryKey().getName();
    }

    QFilter[] getQFilters() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        try {
            Date start = format.parse("2020-01-01 00:00:00");
            Date end = format.parse("2020-12-31 23:59:59");
            QFilter qFilter1 = new QFilter("bringdate", ">=", (Object)start);
            QFilter qFilter2 = new QFilter("bringdate", "<", (Object)end);
            qFilterList.add(qFilter1);
            qFilterList.add(qFilter2);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return qFilterList.toArray(new QFilter[0]);
    }
}

