/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.mq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.mq.ArchiveLogBody;
import kd.bos.archive.repository.ArchiveLogRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;

public class ArchiveLogConsumer
implements MessageConsumer,
ArchiveLogable {
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            String str = (String)body;
            if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
                log.info(MessageFormat.format("ArchiveServiceLog ArchiveLogConsumer body:{0}", str));
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ArchiveLogBody logBody = (ArchiveLogBody)objectMapper.readValue(str, ArchiveLogBody.class);
            ArchiveLogRepository.get().insertLog(logBody);
            acker.ack(messageId);
        }
        catch (Throwable e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
            } else {
                acker.deny(messageId);
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveServiceLog ArchiveLogConsumer onMessage error, messageId:{0}, discard:{1}, errorinfo:{2}", messageId, discard, sw.toString());
            log.error(error, e);
        }
    }
}

