/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.mq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.mq.ArchiveLogBody;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.id.ID;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.xdb.util.DateUtil;

public class ArchiveLogPublish
implements ArchiveLogable {
    public static final ArchiveLogPublish instance = new ArchiveLogPublish();

    public static ArchiveLogPublish get() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishLog(long taskId, String entityName, String lot, String progresstype) {
        try {
            if (null == progresstype) {
                progresstype = "";
            }
            SimpleDateFormat sdf = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
            lot = "[" + sdf.format(new Date()) + "] " + lot;
            long id = ID.genLongId();
            int N = 1333;
            if (lot.length() > 1333) {
                lot = lot.substring(0, 1333);
            }
            if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
                log.info(MessageFormat.format("ArchiveServiceLog ArchiveLogPublish  entitynumber:{0}, taskId:{1}, progresstype:{2}, log:{3}", entityName, taskId, progresstype, log));
            }
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.archive.mq.ArchiveServiceLog");){
                ArchiveLogBody logBody = new ArchiveLogBody(id, taskId, entityName, lot, progresstype, new Date());
                ObjectMapper objectMapper = new ObjectMapper();
                String message = objectMapper.writeValueAsString((Object)logBody);
                pub.publish(message);
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveServiceLog ArchiveLogPublish publishOperationLog error outter, entitynumber:{0}, taskId:{1}, errorinfo:{2}", entityName, taskId, sw.toString());
            log.error(error, e);
        }
    }
}

