/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.progress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.progress.IProgress;
import kd.bos.bundle.BosRes;
import kd.bos.exception.KDExceptionKit;
import kd.bos.xdb.util.DateUtil;

abstract class BaseProgress
implements IProgress,
Serializable,
ArchiveLogable {
    private static final long serialVersionUID = -8345327702729155660L;
    protected long taskId;
    protected String entitynumber;
    protected int runRound = 0;
    protected long tsUsed = 0L;
    protected long tsLastFrom = 0L;
    protected boolean continueSharding = false;
    protected boolean needDel = false;
    protected Object toPk = null;
    protected long movingShardingIndex = -1L;
    protected transient long tsLastStore = 0L;
    protected String progressType;
    protected String execSql;
    protected Map<String, Object> progressDescMap = new HashMap<String, Object>();

    BaseProgress() {
    }

    @Override
    public Object getToPk() {
        return this.toPk;
    }

    @Override
    public void setToPk(Object toPk) {
        this.toPk = toPk;
    }

    public long getMovingShardingIndex() {
        return this.movingShardingIndex;
    }

    public void setMovingShardingIndex(long movingShardingIndex) {
        this.movingShardingIndex = movingShardingIndex;
    }

    @Override
    public void setProgressDesc(String key, Object value) {
        if (value == null) {
            this.progressDescMap.remove(key);
        } else {
            this.progressDescMap.put(key, value);
        }
    }

    @Override
    public void setProgressDesc_1(Object value) {
        this.setProgressDesc("p1", value);
        this.setProgressDesc_2(null);
        this.setProgressDesc_3(null);
    }

    @Override
    public void setProgressDesc_2(Object value) {
        this.setProgressDesc("p2", value);
        this.setProgressDesc_3(null);
    }

    @Override
    public void setProgressDesc_3(Object value) {
        this.setProgressDesc("p3", value);
    }

    public void incRunRound() {
        ++this.runRound;
    }

    public String getProgressType() {
        return this.progressType;
    }

    public void setProgressType(String progressType) {
        this.progressType = progressType;
    }

    public String getExecSql() {
        return this.execSql;
    }

    @Override
    public void setExecSql(String execSql) {
        this.execSql = execSql;
    }

    @Override
    public boolean isNeedDel() {
        return this.needDel;
    }

    @Override
    public void setNeedDel(boolean needDel) {
        this.needDel = needDel;
    }

    public String formatUsedTS() {
        long s = this.tsUsed / 1000L;
        if (s < 60L) {
            return BosRes.get((String)"bos-archive", (String)"ArchiveProgress_1", (String)"{0}s", (Object[])new Object[]{s});
        }
        long m = s / 60L;
        if (m < 60L) {
            return BosRes.get((String)"bos-archive", (String)"ArchiveProgress_2", (String)"{0}min{1}s", (Object[])new Object[]{m, s % 60L});
        }
        long h = m / 60L;
        return BosRes.get((String)"bos-archive", (String)"ArchiveProgress_3", (String)"{0}h{1}min{2}s", (Object[])new Object[]{h, m % 60L, s % 60L});
    }

    public String progressDesc() {
        return this.progressDescMap.toString();
    }

    public String progressSign() {
        return this.serialize();
    }

    public String serialize() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(this);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    public static BaseProgress unserialize(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return (BaseProgress)is.readObject();
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    public boolean isContinueSharding() {
        return this.continueSharding && this.toPk != null;
    }

    public void setContinueSharding(boolean continueSharding) {
        this.continueSharding = continueSharding;
    }

    public String progress() {
        return BosRes.get((String)"bos-archive", (String)"ArchiveProgress_0", (String)"Executed {0} times, elapsed time {1}, last start time {2}", (Object[])new Object[]{this.runRound, this.formatUsedTS(), DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss").format(new Date(this.tsLastFrom))});
    }

    @Override
    public abstract void store(boolean var1);

    @Override
    public void store() {
        this.store(true);
    }
}

