/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.progress;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Semaphore;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.BaseProgress;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;

public class MainTaskProgress
extends BaseProgress {
    private static final long serialVersionUID = 3538779506586909042L;
    private boolean curStepExecuted = false;
    private boolean isSplit = false;
    private Date maxModifytime = null;
    private transient Semaphore deletePKSemaphore = new Semaphore(1);

    public static MainTaskProgress of(long taskId, String entitynumber, String s) {
        MainTaskProgress sp;
        if (s == null || s.trim().length() == 0) {
            sp = new MainTaskProgress();
        } else {
            try {
                MainTaskProgress sp2 = (MainTaskProgress)MainTaskProgress.unserialize(s);
                sp2.tsLastFrom = System.currentTimeMillis();
                sp2.continueSharding = true;
                sp2.needDel = true;
                sp2.setExecSql(null);
                sp2.deletePKSemaphore = new Semaphore(1);
                return sp2;
            }
            catch (Exception e) {
                sp = new MainTaskProgress();
            }
        }
        sp.taskId = taskId;
        sp.entitynumber = entitynumber;
        return sp;
    }

    public MainTaskProgress() {
        this.tsLastFrom = System.currentTimeMillis();
    }

    public Semaphore getDeletePKSemaphore() {
        return this.deletePKSemaphore;
    }

    public Date getMaxModifytime() {
        return this.maxModifytime;
    }

    public void setMaxModifytime(Date maxModifytime) {
        this.maxModifytime = maxModifytime;
    }

    public boolean isCurStepExecuted() {
        return this.curStepExecuted;
    }

    public void setCurStepExecuted(boolean curStepExecuted) {
        this.curStepExecuted = curStepExecuted;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean split) {
        this.isSplit = split;
    }

    @Override
    public void store(boolean isLog) {
        long segUsed = this.tsLastStore == 0L ? System.currentTimeMillis() - this.tsLastFrom : System.currentTimeMillis() - this.tsLastStore;
        this.tsUsed += segUsed;
        this.tsLastStore = System.currentTimeMillis();
        StringBuilder sql = new StringBuilder();
        sql.append("update ");
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.isSplit) {
            sql.append(" t_cbs_archi_splittask set fprogresssign = ? ");
            params.add(this.progressSign());
        } else {
            sql.append(" t_cbs_archi_task set fprogress = ?, fprogressdesc = ?, fprogresssign = ? ");
            params.add(this.progress());
            params.add(this.progressDesc());
            params.add(this.progressSign());
        }
        sql.append(" where fid = ? ");
        params.add(this.taskId);
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])params.toArray());
        String msg = this.progress() + "\r\n" + this.progressDesc();
        if (!StringUtils.isEmpty((String)this.execSql)) {
            msg = msg + "\r\n" + this.execSql;
        }
        if (isLog) {
            ArchiveLogPublish.get().publishLog(this.taskId, this.entitynumber, msg, this.progressType);
        }
    }
}

