/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.progress;

import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.BaseProgress;
import kd.bos.archive.progress.MainTaskProgress;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;

public class SubTaskProgress
extends BaseProgress {
    private static final long serialVersionUID = 7930177781750563120L;
    private String movingTable;
    private MainTaskProgress parentSp;

    public static SubTaskProgress of(long taskId, String entitynumber, String s, MainTaskProgress parentSp) {
        SubTaskProgress sp;
        if (s == null || s.trim().length() == 0) {
            sp = new SubTaskProgress();
        } else {
            try {
                SubTaskProgress sp2 = (SubTaskProgress)SubTaskProgress.unserialize(s);
                sp2.tsLastFrom = System.currentTimeMillis();
                sp2.needDel = true;
                sp2.setExecSql(null);
                ++sp2.runRound;
                return sp2;
            }
            catch (Exception e) {
                sp = new SubTaskProgress();
            }
        }
        sp.taskId = taskId;
        sp.entitynumber = entitynumber;
        sp.parentSp = parentSp;
        return sp;
    }

    public SubTaskProgress() {
        this.tsLastFrom = System.currentTimeMillis();
    }

    public String getMovingTable() {
        return this.movingTable;
    }

    public void setMovingTable(String movingTable) {
        this.movingTable = movingTable;
    }

    public MainTaskProgress getParentSp() {
        return this.parentSp;
    }

    @Override
    public void store(boolean isLog) {
        long segUsed = this.tsLastStore == 0L ? System.currentTimeMillis() - this.tsLastFrom : System.currentTimeMillis() - this.tsLastStore;
        this.tsUsed += segUsed;
        this.tsLastStore = System.currentTimeMillis();
        String sql = "update t_cbs_archi_subtask set fprogresssign = ? where fid = ? ";
        Object[] parmas = new Object[]{this.progressSign(), this.taskId};
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])parmas);
        String msg = this.progress() + "\r\n" + this.progressDesc();
        if (!StringUtils.isEmpty((String)this.execSql)) {
            msg = msg + "\r\n" + this.execSql;
        }
        if (isLog) {
            ArchiveLogPublish.get().publishLog(this.taskId, this.entitynumber, msg, this.progressType);
        }
    }
}

