/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveConfigRefbdEntity;
import kd.bos.archive.repository.ArchiveConfigRefbdRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class ArchiveConfigRefbdRepositoryImpl
implements ArchiveConfigRefbdRepository,
ArchiveLogable {
    public static final ArchiveConfigRefbdRepositoryImpl instance = new ArchiveConfigRefbdRepositoryImpl();

    @Override
    public List<ArchiveConfigRefbdEntity> loadConfigRefbdList(long configId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select fid,fentryid,fseq, fbdnumber,fbdname,fcustom,ftimeattr,fbd ");
        sql.append(" from t_cbs_archi_config_refbd ");
        sql.append(" where fid = ? ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{configId}, rs -> {
            ArrayList<ArchiveConfigRefbdEntity> list = new ArrayList<ArchiveConfigRefbdEntity>(16);
            while (rs.next()) {
                ArchiveConfigRefbdEntity refbdEntity = new ArchiveConfigRefbdEntity();
                refbdEntity.setFid(configId);
                refbdEntity.setEntryid(rs.getLong(2));
                refbdEntity.setSeq(rs.getInt(3));
                refbdEntity.setBdnumber(rs.getString(4));
                refbdEntity.setBdname(rs.getString(5));
                refbdEntity.setCustom(rs.getString(6));
                refbdEntity.setTimeAttr(rs.getString(7));
                refbdEntity.setBd(rs.getString(8));
                list.add(refbdEntity);
            }
            return list;
        });
    }

    @Override
    public void delSurplusNum(List<Long> findSurplus) {
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from t_cbs_archi_config_refbd ");
        sql.append(" where fentryid in( ");
        int n = findSurplus.size();
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                sql.append("?");
                continue;
            }
            sql.append("?,");
        }
        sql.append(" ) ");
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])findSurplus.toArray());
    }

    @Override
    public void insertLackedNum(List<Object[]> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_config_refbd(");
        sql.append(" fid,fentryid,fseq,fbdnumber,fbdname,fbd,fcustom,ftimeattr ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramsList);
        }
    }

    @Override
    public String getTimeAttr(long configId, String entityNumber) {
        String sql = "select ftimeattr from t_cbs_archi_config_refbd where fid = ? and fbdnumber = ?";
        return (String)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{configId, entityNumber}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return null;
        });
    }

    @Override
    public boolean existBasedata(long configId, String entityNumber) {
        String sql = "select count(*) from t_cbs_archi_config_refbd where fid = ? and fbdnumber = ?";
        Integer cnt = (Integer)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{configId, entityNumber}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
            return 0;
        });
        return cnt != 0;
    }

    @Override
    public int getMaxSeq(long configId, String entityNumber) {
        String sql = "select max(fseq) from t_cbs_archi_config_refbd where fid = ? and fbdnumber = ?";
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{configId, entityNumber}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
            return 0;
        });
    }

    @Override
    public void deleteBasedata(long configId, String entityNumber, boolean isForce) {
        String sql = "delete from t_cbs_archi_config_refbd where fid = ? and fbdnumber = ?";
        if (!isForce) {
            sql = sql + " and fcustom = '1'";
        }
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{configId, entityNumber});
    }

    @Override
    public void updateTimeAttr(long configId, String entityNumber, String timeAttr) {
        String sql = "update t_cbs_archi_config_refbd set ftimeattr = ? where fid = ? and fbdnumber = ? ";
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{timeAttr, configId, entityNumber});
    }
}

