/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveConfigEntity;
import kd.bos.archive.enums.ArchiveConfigFilterTypeEnum;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.archive.repository.ArchiveConfigRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.util.StringUtils;

public class ArchiveConfigRepositoryImpl
implements ArchiveConfigRepository,
ArchiveLogable {
    public static final ArchiveConfigRepositoryImpl instance = new ArchiveConfigRepositoryImpl();

    @Override
    public List<ArchiveConfigEntity> loadConfigList(String condition) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" c.fid,c.fentitynumber,c.fcondition,c.ffiltertype,c.farchiveplugin,c.fmovingtype ");
        sql.append(" ,p.fdatabase,p.farchiveroute,p.fdatabase_type ");
        sql.append(" from t_cbs_archi_config c left join t_cbs_archi_database p on c.fgroupid = p.fid");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), rs -> {
            ArrayList<ArchiveConfigEntity> ret = new ArrayList<ArchiveConfigEntity>(100);
            while (rs.next()) {
                ArchiveConfigEntity configEntity = new ArchiveConfigEntity();
                configEntity.setId(rs.getLong("fid"));
                configEntity.setEntitynumber(rs.getString("fentitynumber"));
                configEntity.setCondition(rs.getString("fcondition"));
                configEntity.setArchivePlugin(rs.getString("farchiveplugin"));
                configEntity.setFilterType(ArchiveConfigFilterTypeEnum.from(rs.getString("ffiltertype")));
                ArchiveConfigMovingTypeEnum fmovingtype = ArchiveConfigMovingTypeEnum.from(rs.getString("fmovingtype"));
                configEntity.setMovingType(fmovingtype);
                if (ArchiveConfigMovingTypeEnum.CLEAR != fmovingtype && StringUtils.isNotEmpty((String)rs.getString("farchiveroute"))) {
                    configEntity.setArchiveRoute(rs.getString("farchiveroute"));
                    configEntity.setRouteType(ArchiveRouteType.from((String)rs.getString("fdatabase_type")));
                }
                ret.add(configEntity);
            }
            return ret;
        });
    }

    @Override
    public ArchiveConfigEntity loadConfigToSync(long configId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fentitynumber,fcondition,ffiltertype,farchiveplugin,fmovingtype ");
        sql.append(" ,fregion,ftarget_type ");
        sql.append(" from t_cbs_archi_config ");
        sql.append(" where ").append(" fid = ? ");
        return (ArchiveConfigEntity)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{configId}, rs -> {
            if (rs.next()) {
                ArchiveConfigEntity configEntity = new ArchiveConfigEntity();
                configEntity.setId(rs.getLong("fid"));
                configEntity.setEntitynumber(rs.getString("fentitynumber"));
                configEntity.setCondition(rs.getString("fcondition"));
                configEntity.setArchivePlugin(rs.getString("farchiveplugin"));
                configEntity.setFilterType(ArchiveConfigFilterTypeEnum.from(rs.getString("ffiltertype")));
                ArchiveConfigMovingTypeEnum fmovingtype = ArchiveConfigMovingTypeEnum.from(rs.getString("fmovingtype"));
                configEntity.setMovingType(fmovingtype);
                configEntity.setRegion(rs.getString("fregion"));
                configEntity.setTargetType(rs.getString("ftarget_type"));
                return configEntity;
            }
            return null;
        });
    }

    @Override
    public ArchiveConfigEntity loadConfig(long configId) {
        String condition = " c.fid = " + configId;
        List<ArchiveConfigEntity> ret = this.loadConfigList(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<ArchiveConfigEntity> loadScheduleConfigList(long scheduleId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.fid as fconfigid, a.fentitynumber, a.ffiltertype,a.fmovingtype,a.ftarget_type ");
        sql.append(" from t_cbs_archi_config a inner join t_cbs_archi_scheduleentry b on a.fid = b.fconfigid");
        sql.append(" where b.fid = ? and a.fenable=? ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{scheduleId, Boolean.TRUE}, rs -> {
            ArrayList<ArchiveConfigEntity> list = new ArrayList<ArchiveConfigEntity>(16);
            while (rs.next()) {
                ArchiveConfigEntity obj = new ArchiveConfigEntity();
                obj.setId(rs.getLong(1));
                obj.setEntitynumber(rs.getString(2));
                obj.setFilterType(null != rs.getString(3) ? ArchiveConfigFilterTypeEnum.from(rs.getString(3)) : ArchiveConfigFilterTypeEnum.BILL);
                obj.setMovingType(null != rs.getString(4) ? ArchiveConfigMovingTypeEnum.from(rs.getString(4)) : ArchiveConfigMovingTypeEnum.ARCHIVE);
                obj.setTargetType(rs.getString(5));
                list.add(obj);
            }
            return list;
        });
    }
}

