/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.id.ID;

public class ArchiveEntityRepositoryImpl
implements ArchiveEntityRepository {
    public static final ArchiveEntityRepositoryImpl instance = new ArchiveEntityRepositoryImpl();

    @Override
    public List<ArchiveEntityEntity> loadArchiveEntityList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fentitynumber,farchiveroute,farchivecount,freversecount,fcreatetime,fdatabase_type ");
        sql.append(" from t_cbs_archi_entity  ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])(paramList == null ? null : paramList.toArray()), rs -> {
            ArrayList<ArchiveEntityEntity> ret = new ArrayList<ArchiveEntityEntity>(100);
            while (rs.next()) {
                ArchiveEntityEntity entityrcd = new ArchiveEntityEntity();
                entityrcd.setId(rs.getLong(1));
                entityrcd.setEntitynumber(rs.getString(2));
                entityrcd.setArchiveRoute(rs.getString(3));
                entityrcd.setArchivecount(rs.getLong(4));
                entityrcd.setReversecount(rs.getLong(5));
                entityrcd.setCreatetime(rs.getTimestamp(6));
                entityrcd.setRouteType(ArchiveRouteType.from((String)rs.getString(7)));
                ret.add(entityrcd);
            }
            return ret;
        });
    }

    @Override
    public List<String> loadArchiveRouteList(String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" farchiveroute ");
        sql.append(" from t_cbs_archi_entity  ");
        sql.append(" where  fentitynumber = ? ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{entityNumber}, rs -> {
            ArrayList<String> ret = new ArrayList<String>(100);
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            return ret;
        });
    }

    @Override
    public ArchiveEntityEntity loadArchiveEntity(long entityrcdId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityrcdId);
        List<ArchiveEntityEntity> ret = this.loadArchiveEntityList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public ArchiveEntityEntity loadArchiveEntity(String entityNumber, String archiveRoute) {
        String condition = " fentitynumber = ? and farchiveroute = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(entityNumber);
        paramList.add(archiveRoute);
        List<ArchiveEntityEntity> ret = this.loadArchiveEntityList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<String> loadArchiveEntity(String entityNumber) {
        String condition = " fentitynumber = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ArchiveEntityEntity> ret = this.loadArchiveEntityList(condition, paramList);
        return ret.isEmpty() ? null : ret.stream().map(ArchiveEntityEntity::getArchiveRoute).collect(Collectors.toList());
    }

    @Override
    public List<ArchiveEntityEntity> loadArchiveEntityList(String entityNumber) {
        String condition = " fentitynumber = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ArchiveEntityEntity> ret = this.loadArchiveEntityList(condition, paramList);
        return ret;
    }

    @Override
    public boolean checkEntityExist(String entityNumber, String archiveRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_entity ");
        sql.append(" where  fentitynumber = ? and farchiveroute = ? ");
        ArrayList<String> paramList = new ArrayList<String>(2);
        paramList.add(entityNumber);
        paramList.add(archiveRoute);
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            if (rs.next() && rs.getLong(1) > 0L) {
                return true;
            }
            return false;
        });
    }

    @Override
    public void insertEntity(String entityNumber, String archiveRoute, long archiveCount, ArchiveRouteType routeType) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_entity(");
        sql.append(" fid,fentitynumber,fdatabase_type,farchiveroute,farchivecount,freversecount,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,? ");
        sql.append(" ) ");
        Object[] obj = new Object[]{ID.genLongId(), entityNumber, routeType.getKey(), archiveRoute, archiveCount, 0L, new Date()};
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])obj);
    }

    @Override
    public void incArchiveCount(long fid, long incCount) {
        String sql = "update t_cbs_archi_entity set farchivecount= farchivecount + ? where fid =? ";
        Object[] parmas = new Object[]{incCount, fid};
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])parmas);
    }

    @Override
    public void incReverseCount(long fid, long incCount) {
        String sql = "update t_cbs_archi_entity set freversecount= freversecount + ? where fid =? ";
        Object[] parmas = new Object[]{incCount, fid};
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])parmas);
    }

    @Override
    public void deleteArchiveRoute(String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" delete ");
        sql.append(" from t_cbs_archi_entity  ");
        sql.append(" where  fentitynumber = ? ");
        DB.execute((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{entityNumber});
    }
}

