/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveLogEntity;
import kd.bos.archive.mq.ArchiveLogBody;
import kd.bos.archive.repository.ArchiveLogRepository;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.xdb.util.DateUtil;

public class ArchiveLogRepositoryImpl
implements ArchiveLogRepository,
ArchiveLogable {
    public static final ArchiveLogRepositoryImpl instance = new ArchiveLogRepositoryImpl();

    @Override
    public void insertLog(long taskId, String entityName, String logStr, String progresstype) {
        String sql = "insert into t_cbs_archi_log(fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime) values (?,?,?,?,?,?)";
        if (null == progresstype) {
            progresstype = "";
        }
        SimpleDateFormat sdf = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
        logStr = "[" + sdf.format(new Date()) + "] " + logStr;
        long id = ID.genLongId();
        int N = 1333;
        if (logStr.length() > 1333) {
            logStr = logStr.substring(0, 1333);
        }
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{id, taskId, entityName, logStr, progresstype, new Date()});
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("ArchiveLog, taskId:{0}, entitynumber:{1}, progresstype:{2}, log:{3}", taskId, entityName, progresstype, log));
        }
    }

    @Override
    public void insertLog(ArchiveLogBody logBody) {
        String sql = "insert into t_cbs_archi_log(fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime) values (?,?,?,?,?,?)";
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{logBody.getId(), logBody.getTaskId(), logBody.getEntityName(), logBody.getLog(), logBody.getProgresstype(), logBody.getDate()});
    }

    @Override
    public ArchiveLogEntity loadLatestLog(long taskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select top 1 ");
        sql.append(" fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime ");
        sql.append(" from t_cbs_archi_log where ftaskid = ? ");
        sql.append(" order by fid desc ");
        return (ArchiveLogEntity)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{taskid}, rs -> {
            if (rs.next()) {
                ArchiveLogEntity logEntity = new ArchiveLogEntity();
                logEntity.setId(rs.getLong("fid"));
                logEntity.setTaskid(rs.getLong("ftaskid"));
                logEntity.setEntitynumber(rs.getString("fentitynumber"));
                logEntity.setOperationlog(rs.getString("foperationlog"));
                logEntity.setProgresstype(rs.getString("fprogresstype"));
                logEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                return logEntity;
            }
            return null;
        });
    }

    @Override
    public ArchiveLogEntity loadLatestLog(String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select top 1 ");
        sql.append(" fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime ");
        sql.append(" from t_cbs_archi_log where fentitynumber = ? ");
        sql.append(" order by fid desc ");
        return (ArchiveLogEntity)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{entityNumber}, rs -> {
            if (rs.next()) {
                ArchiveLogEntity logEntity = new ArchiveLogEntity();
                logEntity.setId(rs.getLong("fid"));
                logEntity.setTaskid(rs.getLong("ftaskid"));
                logEntity.setEntitynumber(rs.getString("fentitynumber"));
                logEntity.setOperationlog(rs.getString("foperationlog"));
                logEntity.setProgresstype(rs.getString("fprogresstype"));
                logEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                return logEntity;
            }
            return null;
        });
    }
}

