/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveCascadeConfigEntity;
import kd.bos.archive.entity.ArchiveConfigEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class ArchiveTaskRepositoryImpl
implements ArchiveTaskRepository,
ArchiveLogable {
    public static final ArchiveTaskRepositoryImpl instance = new ArchiveTaskRepositoryImpl();

    @Override
    public List<ArchiveTaskEntity> loadUnexecutedTaskList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        if (condition != null) {
            sql.append(condition).append(" and ");
        } else {
            paramList = new ArrayList<Object>(2);
        }
        sql.append(" ftaskstatus in(?,?)");
        paramList.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        return this.loadTaskList(sql.toString(), paramList);
    }

    @Override
    public List<ArchiveTaskEntity> loadUnFinishedTaskList(String entitynumber) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(" fentitynumber =? ");
        paramList.add(entitynumber);
        sql.append(" and ftaskstatus in(?,?,?,?)");
        paramList.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ArchiveTaskStatusEnum.FAILED.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        paramList.add(ArchiveTaskStatusEnum.SUSPENDED.getKey());
        return this.loadTaskList(sql.toString(), paramList);
    }

    @Override
    public List<ArchiveTaskEntity> loadFailedTaskListByScheduleId(long scheduleId) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append(" fscheduleid =? ");
        paramList.add(scheduleId);
        sql.append(" and ftaskstatus = ?");
        paramList.add(ArchiveTaskStatusEnum.FAILED.getKey());
        return this.loadTaskList(sql.toString(), paramList);
    }

    @Override
    public List<ArchiveTaskEntity> loadAbortTaskList(String entitynumber) {
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        StringBuilder sql = new StringBuilder();
        sql.append(" fentitynumber =? ");
        paramList.add(entitynumber);
        sql.append(" and ftaskstatus in(?,?,?)");
        paramList.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        paramList.add(ArchiveTaskStatusEnum.CASCADE.getKey());
        return this.loadTaskList(sql.toString(), paramList);
    }

    @Override
    public List<ArchiveTaskEntity> loadTaskList(long scheduleRcdId) {
        String condition = " fschedulercdid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(scheduleRcdId);
        return this.loadTaskList(condition, paramList);
    }

    @Override
    public ArchiveTaskEntity loadUnexecutedTask(long taskId) {
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        StringBuilder sql = new StringBuilder();
        sql.append(" fid = ? ").append(" and ");
        sql.append(" ftaskstatus in(?,?,?)");
        paramList.add(taskId);
        paramList.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
        paramList.add(ArchiveTaskStatusEnum.CASCADE.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        List<ArchiveTaskEntity> ret = this.loadTaskList(sql.toString(), paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<ArchiveTaskEntity> loadBarrierTask(long taskId) {
        String condition = " frootid = ? and ftaskstatus != ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(taskId);
        paramList.add(ArchiveTaskStatusEnum.TERMINATED.getKey());
        return this.loadTaskList(condition, paramList);
    }

    @Override
    public List<ArchiveTaskEntity> loadBarrierTaskList() {
        String condition = " ftaskstatus = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(ArchiveTaskStatusEnum.CASCADE.getKey());
        return this.loadTaskList(condition, paramList);
    }

    @Override
    public List<ArchiveTaskEntity> loadRunningTaskList() {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        sql.append(" ftaskstatus in(?,?)");
        paramList.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        return this.loadTaskList(sql.toString(), paramList);
    }

    private List<ArchiveTaskEntity> loadTaskList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select top 1000 ");
        sql.append(" fid,fparentid,frootid,fentitynumber,ftasktype,ftasknode,ftaskstatus,fstarttime,fendtime,frunnode, ");
        sql.append(" frunhost,fruninstance,fscheduleid,fschedulercdid,fbatchnum,fconfigid,ftotalcount,fbarriercount,fprogress,fprogressdesc, ");
        sql.append(" fprogresssign,fhost,fprepk,findex,fcreatetime,fmodifytime,fretrytimes,flastretrytime ");
        sql.append(" from t_cbs_archi_task ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        sql.append(" order by fid asc");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            ArrayList<ArchiveTaskEntity> ret = new ArrayList<ArchiveTaskEntity>(100);
            while (rs.next()) {
                ArchiveTaskEntity taskEntity = new ArchiveTaskEntity();
                taskEntity.setId(rs.getLong("fid"));
                taskEntity.setParentid(rs.getLong("fparentid"));
                taskEntity.setRootid(rs.getLong("frootid"));
                taskEntity.setEntitynumber(rs.getString("fentitynumber"));
                taskEntity.setTasktype(ArchiveTaskTypeEnum.from(rs.getString("ftasktype")));
                taskEntity.setTasknode(ArchiveTaskNodeEnum.from(rs.getString("ftasknode")));
                taskEntity.setTaskstatus(ArchiveTaskStatusEnum.from(rs.getString("ftaskstatus")));
                taskEntity.setStarttime(rs.getTimestamp("fstarttime"));
                taskEntity.setEndtime(rs.getTimestamp("fendtime"));
                taskEntity.setRunnode(rs.getString("frunnode"));
                taskEntity.setRunhost(rs.getString("frunhost"));
                taskEntity.setRuninstance(rs.getString("fruninstance"));
                taskEntity.setScheduleid(rs.getLong("fscheduleid"));
                taskEntity.setSchedulercdid(rs.getLong("fschedulercdid"));
                taskEntity.setBatchnum(rs.getString("fbatchnum"));
                taskEntity.setConfigid(rs.getLong("fconfigid"));
                taskEntity.setTotalcount(rs.getLong("ftotalcount"));
                taskEntity.setBarriercount(rs.getLong("fbarriercount"));
                taskEntity.setProgress(rs.getString("fprogress"));
                taskEntity.setProgressdesc(rs.getString("fprogressdesc"));
                taskEntity.setProgresssign(rs.getString("fprogresssign"));
                taskEntity.setHost(rs.getString("fhost"));
                taskEntity.setPrepk(rs.getString("fprepk"));
                taskEntity.setIndex(rs.getInt("findex"));
                taskEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                taskEntity.setModifytime(rs.getTimestamp("fmodifytime"));
                taskEntity.setRetrytimes(rs.getInt("fretrytimes"));
                taskEntity.setLastretrytime(rs.getTimestamp("flastretrytime"));
                ret.add(taskEntity);
            }
            return ret;
        });
    }

    @Override
    public ArchiveTaskEntity loadTask(long taskId) {
        String condition = " fid = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(taskId);
        List<ArchiveTaskEntity> ret = this.loadTaskList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public int setNextTaskNode(long taskId, ArchiveTaskNodeEnum curNode, ArchiveTaskNodeEnum nextNode) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftasknode = ? ");
        sql.append(" where fid = ? and ftasknode = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{nextNode.getKey(), taskId, curNode.getKey()});
    }

    @Override
    public int setTaskPause(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus = ? and ftasknode in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.PAUSE.getKey(), taskId, ArchiveTaskStatusEnum.EXECUTING.getKey(), ArchiveTaskNodeEnum.PKINSERT.getKey(), ArchiveTaskNodeEnum.DATAMIGRATE.getKey()});
    }

    @Override
    public int setTaskContinue(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.UNEXECUTED.getKey(), taskId, ArchiveTaskStatusEnum.SUSPENDED.getKey(), ArchiveTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setTaskTerminated(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ? , fendtime = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.TERMINATED.getKey(), new Date(), taskId, ArchiveTaskStatusEnum.SUSPENDED.getKey(), ArchiveTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setTaskUnexecuted(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.UNEXECUTED.getKey(), taskId, ArchiveTaskStatusEnum.EXECUTING.getKey(), ArchiveTaskStatusEnum.PAUSE.getKey(), ArchiveTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setTaskSuspended(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ArchiveTaskStatusEnum.SUSPENDED.getKey(), taskId, ArchiveTaskStatusEnum.EXECUTING.getKey(), ArchiveTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int updateExecuting(long taskId, String frunnode, String runhost, String runinstance) {
        return this.setTaskstatus(taskId, ArchiveTaskStatusEnum.UNEXECUTED, ArchiveTaskStatusEnum.EXECUTING, frunnode, runhost, runinstance, true, false);
    }

    @Override
    public int updateCascadeExecuting(long taskId, String frunnode, String runhost, String runinstance) {
        return this.setTaskstatus(taskId, ArchiveTaskStatusEnum.CASCADE, ArchiveTaskStatusEnum.EXECUTING, frunnode, runhost, runinstance, true, false);
    }

    @Override
    public int updateSuccess(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ?, fmodifytime = ? ");
        sql.append(", fendtime = ? ");
        sql.append(" where fid = ? and ftaskstatus = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(5);
        paramList.add(ArchiveTaskStatusEnum.SUCCESS.getKey());
        paramList.add(new Date());
        paramList.add(new Date());
        paramList.add(taskId);
        paramList.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public int updateCascade(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ?, fmodifytime = ? ");
        sql.append(" where fid = ? and ftaskstatus = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(5);
        paramList.add(ArchiveTaskStatusEnum.CASCADE.getKey());
        paramList.add(new Date());
        paramList.add(taskId);
        paramList.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public int setNextTaskstatus(long taskId, ArchiveTaskStatusEnum curTaskstatus, ArchiveTaskStatusEnum nextTaskstatus) {
        return this.setTaskstatus(taskId, curTaskstatus, nextTaskstatus, null, null, null, false, false);
    }

    private int setTaskstatus(long taskId, ArchiveTaskStatusEnum curTaskstatus, ArchiveTaskStatusEnum nextTaskstatus, String frunnode, String runhost, String runinstance, boolean isStart, boolean isEnd) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set ftaskstatus = ?,fmodifytime = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(7);
        paramList.add(nextTaskstatus.getKey());
        paramList.add(new Date());
        if (!StringUtils.isEmpty((String)frunnode)) {
            sql.append(", frunnode = ? ");
            paramList.add(frunnode);
        }
        if (!StringUtils.isEmpty((String)runhost)) {
            sql.append(", frunhost = ? ");
            paramList.add(runhost);
        }
        if (!StringUtils.isEmpty((String)runinstance)) {
            sql.append(", fruninstance = ? ");
            paramList.add(runinstance);
        }
        if (isStart) {
            sql.append(", fstarttime = ? ");
            paramList.add(new Date());
        }
        if (isEnd) {
            sql.append(", fendtime = ? ");
            paramList.add(new Date());
        }
        sql.append(" where fid = ? and ftaskstatus = ? ");
        paramList.add(taskId);
        paramList.add(curTaskstatus.getKey());
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray());
    }

    @Override
    public boolean checkLastConfigEnd(long configId) {
        String condition = " fconfigid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(configId);
        return this.checkLastEnd(condition, paramList);
    }

    @Override
    public boolean checkLastScheduleEnd(long scheduleId) {
        String condition = " fscheduleid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(scheduleId);
        return this.checkLastEnd(condition, paramList);
    }

    private boolean checkLastEnd(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_archi_task ");
        sql.append(" where  ");
        sql.append(condition);
        sql.append(" and ftaskstatus in(?,?,?,?,?,?) ");
        paramList.add(ArchiveTaskStatusEnum.UNEXECUTED.getKey());
        paramList.add(ArchiveTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ArchiveTaskStatusEnum.FAILED.getKey());
        paramList.add(ArchiveTaskStatusEnum.PAUSE.getKey());
        paramList.add(ArchiveTaskStatusEnum.SUSPENDED.getKey());
        paramList.add(ArchiveTaskStatusEnum.CASCADE.getKey());
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            if (rs.next() && rs.getLong(1) == 0L) {
                return true;
            }
            return false;
        });
    }

    @Override
    public int insertTask(long recordId, String batchnum, long scheduleId, List<ArchiveConfigEntity> scheduleConfigList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_task(");
        sql.append(" fid,fparentid,frootid,fscheduleid,fschedulercdid,fbatchnum,fconfigid,fentitynumber,ftasktype,ftotalcount,fpendingcount,ftasknode,ftaskstatus,fhost,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(scheduleConfigList.size());
        String host = ArchiveServiceConfig.isDevMode() ? NetAddressUtils.getLocalIpAddress() : " ";
        for (ArchiveConfigEntity config : scheduleConfigList) {
            ArchiveTaskTypeEnum taskTypeEnum = ArchiveConfigMovingTypeEnum.CLEAR == config.getMovingType() ? ArchiveTaskTypeEnum.DATACLEAN : (ArchiveConfigMovingTypeEnum.SYNC == config.getMovingType() ? ArchiveTaskTypeEnum.ARCHIVESYNC : ArchiveTaskTypeEnum.ARCHIVE);
            long id = ID.genLongId();
            Object[] obj = new Object[]{id, 0L, id, scheduleId, recordId, batchnum, config.getId(), config.getEntitynumber(), taskTypeEnum.getKey(), 0L, 0L, ArchiveTaskNodeEnum.TASKSTART.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), host, new Date()};
            paramsList.add(obj);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramsList);
            ArchiveService.get().submitChangeTask(batchnum);
        }
        return scheduleConfigList.size();
    }

    @Override
    public void insertTaskByCopy(ArchiveTaskEntity preTaskEntity) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_task(");
        sql.append(" fid,fparentid,frootid,fscheduleid,fschedulercdid,fbatchnum,fconfigid,fentitynumber,ftasktype,ftotalcount,fpendingcount,fprepk,findex,ftasknode,ftaskstatus,fhost,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        ArchiveTaskEntity taskEntity = this.loadTask(preTaskEntity.getId());
        long id = ID.genLongId();
        Object[] params = new Object[]{id, 0L, id, taskEntity.getScheduleid(), taskEntity.getSchedulercdid(), taskEntity.getBatchnum(), taskEntity.getConfigid(), taskEntity.getEntitynumber(), taskEntity.getTasktype().getKey(), 0L, 0L, taskEntity.getPrepk(), taskEntity.getIndex(), ArchiveTaskNodeEnum.TASKSTART.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), taskEntity.getHost(), new Date()};
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])params);
    }

    @Override
    public void insertNextIndexTaskByCopy(ArchiveTaskEntity preTaskEntity, long nextIndex) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_task(");
        sql.append(" fid,fparentid,frootid,fscheduleid,fschedulercdid,fbatchnum,fconfigid,fentitynumber,ftasktype,ftotalcount,fpendingcount,fprepk,findex,ftasknode,ftaskstatus,fhost,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        ArchiveTaskEntity taskEntity = this.loadTask(preTaskEntity.getId());
        long id = ID.genLongId();
        Object[] params = new Object[]{id, 0L, id, taskEntity.getScheduleid(), taskEntity.getSchedulercdid(), taskEntity.getBatchnum(), taskEntity.getConfigid(), taskEntity.getEntitynumber(), taskEntity.getTasktype().getKey(), 0L, 0L, 0L, nextIndex, ArchiveTaskNodeEnum.TASKSTART.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), taskEntity.getHost(), new Date()};
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])params);
    }

    @Override
    public int insertCascadeTask(long rootid, ArchiveTaskEntity parentTaskEntity, DBConfiguration configuration) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_task(");
        sql.append(" fid,fparentid,frootid,fscheduleid,fschedulercdid,fbatchnum,fconfigid,fentitynumber,ftasktype,ftotalcount,fpendingcount,fbarriercount,ftasknode,ftaskstatus,fhost,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(configuration.getChildCascadeConfigs().size());
        String host = ArchiveServiceConfig.isDevMode() ? NetAddressUtils.getLocalIpAddress() : " ";
        for (ArchiveCascadeConfigEntity config : configuration.getChildCascadeConfigs()) {
            if (parentTaskEntity.getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE && !DB.exitsTableForManager((DBRoute)configuration.getFromRoute(), (String)(configuration.getMainTable() + configuration.getConfigEntity().getLogicSuffix()))) continue;
            Object[] obj = new Object[]{ID.genLongId(), parentTaskEntity.getId(), rootid, parentTaskEntity.getScheduleid(), parentTaskEntity.getSchedulercdid(), parentTaskEntity.getBatchnum(), parentTaskEntity.getConfigid(), config.getEntitynumber(), parentTaskEntity.getTasktype().getKey(), 0L, 0L, 0L, ArchiveTaskNodeEnum.TASKSTART.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), host, new Date()};
            paramsList.add(obj);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramsList);
        }
        return paramsList.size();
    }

    @Override
    public void insertReverseTask(long taskId, long recordId, String batchnum, long archiveEntityId, String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_task(");
        sql.append(" fid,fparentid,frootid,fschedulercdid,fbatchnum,fconfigid,fentitynumber,ftasktype,ftotalcount,fpendingcount,ftasknode,ftaskstatus,fhost,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        String host = ArchiveServiceConfig.isDevMode() ? NetAddressUtils.getLocalIpAddress() : " ";
        Object[] obj = new Object[]{taskId, 0L, taskId, recordId, batchnum, archiveEntityId, entityNumber, ArchiveTaskTypeEnum.UNARCHIVE.getKey(), 0L, 0L, ArchiveTaskNodeEnum.TASKSTART.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), host, new Date()};
        DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])obj);
    }

    @Override
    public int insertBdDatasyncTask(long recordId, String batchnum, long configId, Set<String> baseSet) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_cbs_archi_task(");
        sql.append(" fid,fparentid,fschedulercdid,fbatchnum,fconfigid,fentitynumber,ftasktype,ftotalcount,fpendingcount,ftasknode,ftaskstatus,fhost,fcreatetime ");
        sql.append(" ) values( ");
        sql.append(" ?,?,?,?,?,?,?,?,?,?,?,?,? ");
        sql.append(" ) ");
        if (baseSet.size() > 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(baseSet.size());
            String host = ArchiveServiceConfig.isDevMode() ? NetAddressUtils.getLocalIpAddress() : " ";
            for (String entityNumber : baseSet) {
                Object[] obj = new Object[]{ID.genLongId(), 0L, recordId, batchnum, configId, entityNumber, ArchiveTaskTypeEnum.DATASYNC.getKey(), 0L, 0L, ArchiveTaskNodeEnum.TASKSTART.getKey(), ArchiveTaskStatusEnum.UNEXECUTED.getKey(), host, new Date()};
                paramsList.add(obj);
            }
            DB.executeBatch((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramsList);
        }
        return baseSet.size();
    }

    @Override
    public void incTotalCount(long taskId, long incCount) {
        String sql = "update t_cbs_archi_task set ftotalcount= ftotalcount + ? where fid =? ";
        Object[] parmas = new Object[]{incCount, taskId};
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])parmas);
    }

    @Override
    public long getScheduleByEntitynumber(String entitynumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select A.fid ");
        sql.append(" from t_cbs_archi_schedule A , t_cbs_archi_scheduleentry B , t_cbs_archi_config C  ");
        sql.append(" where A.fid = B.fid and B.fconfigid = C.fid and C.fentitynumber = ?  ");
        return (Long)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{entitynumber}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    @Override
    public int updateBarriercount(long taskId, long barriercount) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set fbarriercount = ? ");
        sql.append(" where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{barriercount, taskId});
    }

    @Override
    public int decrBarriercount(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set fbarriercount = fbarriercount - 1 ");
        sql.append(" where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{taskId});
    }

    @Override
    public int updatePrepk(long taskId, String prepk) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set fprepk = ? ");
        sql.append(" where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{prepk, taskId});
    }

    @Override
    public int updateIndex(long taskId, long index) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set findex = ? ");
        sql.append(" where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{index, taskId});
    }

    @Override
    public boolean checkTaskEnd(long taskId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(taskId);
        return this.checkLastEnd(condition, paramList);
    }

    @Override
    public int updateTaskRetryInfo(int retryTimes, long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_archi_task ");
        sql.append(" set fretrytimes = ?, flastretrytime = ?");
        sql.append(" where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{retryTimes, new Date(), taskId});
    }

    @Override
    public List<ArchiveTaskEntity> loadFailedTaskList() {
        String condition = " ftaskstatus = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(ArchiveTaskStatusEnum.FAILED.getKey());
        return this.loadTaskList(condition, paramList);
    }
}

