/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.route.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.route.index.ArchiveRouteCondition;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.db.archive.DBArchiveRuntime;
import kd.bos.db.archive.config.ArchiveIndexConfig;
import kd.bos.orm.util.CollectionUtils;

public final class ArchiveRouteIndex {
    public static List<String> getArchiveRoute(DBRoute dbRoute, String tableName, boolean isMapRoute, ArchiveRouteCondition ... conditions) {
        ArrayList<String> emptyList = new ArrayList<String>();
        if (!AccountEnable.isAccountEnable()) {
            return emptyList;
        }
        DBArchiveRuntime.get().loadArchiveIndexConfigs(false);
        ArchiveIndexConfig config = DBArchiveManager.get().getArchiveConfigProvider().getIndexConfig(tableName);
        if (config == null || config.getIndexFields() == null || !config.isIndexTbExists()) {
            return emptyList;
        }
        if (conditions.length == 0) {
            return emptyList;
        }
        ArrayList<ArchiveRouteCondition> availableCondition = new ArrayList<ArchiveRouteCondition>(8);
        List<String> indexFieldList = Arrays.asList(config.getIndexFields());
        for (ArchiveRouteCondition condition : conditions) {
            if (!indexFieldList.contains(condition.field)) continue;
            availableCondition.add(condition);
        }
        if (CollectionUtils.isEmpty(availableCondition)) {
            return emptyList;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct(farchiveroute) from ").append(ArchiveName.of((String)tableName).getArchivePkTable()).append(" where ");
        ArrayList<Object> params = new ArrayList<Object>(availableCondition.size());
        for (int i = 0; i < availableCondition.size(); ++i) {
            sql.append(((ArchiveRouteCondition)availableCondition.get((int)i)).field).append(" = ? ");
            params.add(((ArchiveRouteCondition)availableCondition.get((int)i)).value);
            if (i == availableCondition.size() - 1) continue;
            sql.append(" and ");
        }
        List<String> archiveRoutes = (List<String>)DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])params.toArray(), rs -> {
            ArrayList<String> ret = new ArrayList<String>(1);
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            return ret;
        });
        if ((archiveRoutes = archiveRoutes.stream().distinct().collect(Collectors.toList())).size() == 1 && isMapRoute) {
            ArchiveRoute.mapRoute((String)dbRoute.getRouteKey(), (String)archiveRoutes.get(0));
        }
        return archiveRoutes;
    }
}

