/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.schedule;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.archive.changetask.ArchiveChangeTaskNotifier;
import kd.bos.archive.config.AccountArchiveConfigService;
import kd.bos.archive.config.AccountArchiveEnableChangedNotifier;
import kd.bos.archive.config.ArchiveParameters;
import kd.bos.archive.schedule.cron.CronService;
import kd.bos.archive.schedule.task.ScheduleService;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.resultnotify.DBArchiveResultNotifier;
import kd.bos.archive.util.Apps;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ScheduleServiceStarter
implements Service {
    private static final String SIMPLE_NAME = ScheduleServiceStarter.class.getSimpleName();
    private static final Log log = LogFactory.getLog(ScheduleServiceStarter.class);
    private AtomicBoolean started = new AtomicBoolean();

    public String getName() {
        return SIMPLE_NAME;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        if (ArchiveServiceConfig.isEnable() && this.started.compareAndSet(false, true)) {
            AccountArchiveEnableChangedNotifier.registerReloadArchiveAccountEnableListener(accountArchiveInfo -> ArchiveParameters.onAccountArchiveEnableChanged(accountArchiveInfo.getAccountId(), accountArchiveInfo.isEnable()));
            AccountArchiveConfigService.get().start(() -> {
                if (Apps.isCurrentNodeDeployApp(ArchiveServiceConfig.getRunningAppId())) {
                    DBArchiveResultNotifier.registerArchiveResultNotifyListener(di -> log.info("[DBArchiveResultNotifier] registerArchiveResultNotifyListener " + di));
                    ArchiveChangeTaskNotifier.registerChangeTaskListener(di -> {
                        log.info("[ArchiveChangeTaskNotifier] changeTaskListener " + di);
                        ArchiveService.get().fireHeartBeat(di);
                    });
                    ArchiveService.get().start();
                }
            });
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            AccountArchiveConfigService.get().stop();
            CronService.get().stopService();
            ScheduleService.get().stop();
            ArchiveService.get().stop();
        }
    }
}

