/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.schedule.task;

import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.schedule.cron.CronTask;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ha.component.ComponentStatusManager;
import kd.bos.instance.Instance;
import kd.bos.xdb.eventbus.StoreBase;
import kd.bos.xdb.eventbus.db.DBStore;
import kd.bos.xdb.eventbus.redis.RedisStore;

public final class ScheduleTaskStore {
    private static StoreBase rs = ComponentStatusManager.isException((String)"redis.serversForCache") ? new DBStore(Instance.getClusterName() + "#ArchiveTask#", 120) : new RedisStore(Instance.getClusterName() + "#ArchiveTask#", 120);

    public static List<CronTask> loadCronTaskList() {
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)"select fid,fcronexpr,fstarttime,fendtime from t_cbs_archi_schedule where fenable=?", (Object[])new Object[]{Boolean.TRUE}, rs -> {
            ArrayList<CronTask> list = new ArrayList<CronTask>(16);
            while (rs.next()) {
                CronTask task = new CronTask(rs.getLong(1), rs.getString(2), rs.getTimestamp(3), rs.getTimestamp(4));
                list.add(task);
            }
            return list;
        });
    }

    public static boolean isRunning(long id) {
        return "1".equals(rs.get(id + ".running"));
    }

    public static void markStop(long id) {
        rs.set(id + ".stop", (Object)"1");
    }

    public static boolean isMarkStop(long id) {
        return "1".equals(rs.get(id + ".stop"));
    }

    static void onStopped(long id) {
        rs.remove(id + ".running");
        rs.remove(id + ".stop");
    }

    static void keepRunning(long id, boolean forceKeep) {
        if (forceKeep || ScheduleTaskStore.isRunning(id)) {
            rs.set(id + ".running", (Object)"1");
        }
    }
}

