/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.service.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.archive.config.AccountEnable;
import kd.bos.util.ConfigurationUtil;

public final class ArchiveServiceConfig {
    private static AtomicBoolean archiveMovingEnable = new AtomicBoolean(true);
    private static final String runningAppId = System.getProperty("archive.running.appid", "bos");
    private static long scanInterval = 30000L;
    private static int archiveMovingThreads = 4;
    private static long movingInterval = 5000L;
    private static Map<String, Set<String>> movingItems = new HashMap<String, Set<String>>();
    private static boolean enableLog = false;
    private static boolean enableParallel = true;
    private static boolean enableAllEntityClean = false;
    private static boolean enableRelay = true;
    private static boolean enableTrantbBack = true;
    private static boolean indexStandardLimit = true;
    private static boolean archiveSplitDelEnable = true;
    private static int parallelThreads = Runtime.getRuntime().availableProcessors() * 4;
    private static boolean devMode = false;
    private static boolean taskAbortRetryEnable = true;
    private static int taskRunningTimeOut = 10;
    private static long taskEmptyLoopTimes = 20L;
    private static int taskRetryUpLimitTimes = 3;
    private static long taskRetryTimeInterval = 300000L;
    private static long taskRetryDelayTime = 300000L;

    public static boolean isEnable() {
        return AccountEnable.isEnable();
    }

    public static Map<String, Set<String>> getMovingItems() {
        return movingItems;
    }

    public static boolean canMovingAccountId(String accountId) {
        return movingItems.isEmpty() || movingItems.containsKey(accountId);
    }

    public static boolean canMovingEntityName(String accountId, String entityName) {
        if (movingItems.isEmpty()) {
            return true;
        }
        Set<String> set = movingItems.get(accountId);
        if (set != null) {
            return set.contains("*") || set.contains(entityName);
        }
        return false;
    }

    public static String getRunningAppId() {
        return runningAppId;
    }

    public static long getScanInterval() {
        return scanInterval;
    }

    public static int getArchiveMovingThreads() {
        return archiveMovingThreads;
    }

    public static long getMovingInterval() {
        return movingInterval;
    }

    public static boolean isEnableLog() {
        return enableLog;
    }

    public static boolean isEnableParallel() {
        return enableParallel;
    }

    public static boolean isArchiveSplitDelEnable() {
        return archiveSplitDelEnable;
    }

    public static int getParallelThreads() {
        return parallelThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForArchiveMovingEnable() {
        if (!archiveMovingEnable.get()) {
            AtomicBoolean atomicBoolean = archiveMovingEnable;
            synchronized (atomicBoolean) {
                while (!archiveMovingEnable.get()) {
                    try {
                        archiveMovingEnable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private static void splitEntityName(String s, Map<String, Set<String>> map) {
        String accountId;
        int i = (s = s.trim()).indexOf(61);
        if (i != -1 && (accountId = s.substring(0, i).trim()).length() > 0) {
            if (s.endsWith("=")) {
                map.put(accountId, new HashSet());
            } else {
                String[] entityNames = s.substring(i + 1).split(",");
                HashSet<String> set = new HashSet<String>(entityNames.length);
                for (String name : entityNames) {
                    set.add(name.trim().toLowerCase());
                }
                map.put(accountId, set);
            }
        }
    }

    public static boolean isDevMode() {
        return devMode;
    }

    public static boolean isTaskAbortRetryEnable() {
        return taskAbortRetryEnable;
    }

    public static int getTaskRunningTimeOut() {
        return taskRunningTimeOut;
    }

    public static boolean isEnableAllEntityClean() {
        return enableAllEntityClean;
    }

    public static boolean isEnableRelay() {
        return enableRelay;
    }

    public static boolean isEnableTrantbBack() {
        return enableTrantbBack;
    }

    public static boolean isIndexStandardLimit() {
        return indexStandardLimit;
    }

    public static long getTaskEmptyLoopTimes() {
        return taskEmptyLoopTimes;
    }

    public static int getTaskRetryUpLimitTimes() {
        return taskRetryUpLimitTimes;
    }

    public static long getTaskRetryTimeInterval() {
        return taskRetryTimeInterval;
    }

    public static long getTaskRetryDelayTime() {
        return taskRetryDelayTime;
    }

    static {
        ConfigurationUtil.observeString((String)"archive.moving.items", (String)"", v -> {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            if (v != null && v.length() > 0) {
                String[] ss;
                for (String s : ss = v.split(";")) {
                    ArchiveServiceConfig.splitEntityName(s, map);
                }
            }
            movingItems = map;
        });
        ConfigurationUtil.observeBoolean((String)"archive.moving.enable", (boolean)archiveMovingEnable.get(), v -> {
            archiveMovingEnable.set((boolean)v);
            AtomicBoolean atomicBoolean = archiveMovingEnable;
            synchronized (atomicBoolean) {
                archiveMovingEnable.notifyAll();
            }
        });
        ConfigurationUtil.observeLong((String)"archive.scanInterval", (long)scanInterval, v -> {
            scanInterval = v;
        });
        ConfigurationUtil.observeBoolean((String)"archive.log", (boolean)false, v -> {
            enableLog = v;
        });
        ConfigurationUtil.observeBoolean((String)"archive.split.del.enable", (boolean)true, v -> {
            archiveSplitDelEnable = v;
        });
        ConfigurationUtil.observeLong((String)"archive.moving.interval", (long)movingInterval, v -> {
            movingInterval = v;
        });
        ConfigurationUtil.observeBoolean((String)"archive.devmode", (boolean)false, v -> {
            devMode = v;
        });
        archiveMovingThreads = Integer.parseInt(System.getProperty("archive.moving.threads", String.valueOf(archiveMovingThreads)));
        enableParallel = Boolean.parseBoolean(System.getProperty("archive.parallel.enable", "true"));
        parallelThreads = Integer.parseInt(System.getProperty("archive.parallel.threads", String.valueOf(parallelThreads)));
        ConfigurationUtil.observeBoolean((String)"archive.task.abort.retry.enable", (boolean)true, v -> {
            taskAbortRetryEnable = v;
        });
        ConfigurationUtil.observeBoolean((String)"archive.allEntity.clean.enable", (boolean)true, v -> {
            enableAllEntityClean = v;
        });
        ConfigurationUtil.observeBoolean((String)"archive.relay.enable", (boolean)true, v -> {
            enableRelay = v;
        });
        ConfigurationUtil.observeBoolean((String)"archive.tran.back.enable", (boolean)true, v -> {
            enableTrantbBack = v;
        });
        ConfigurationUtil.observeInteger((String)"archive.task.running.time.out", (int)10, v -> {
            taskRunningTimeOut = v;
        });
        ConfigurationUtil.observeLong((String)"archive.task.empty.loop.times", (long)20L, v -> {
            taskEmptyLoopTimes = v;
        });
        ConfigurationUtil.observeBoolean((String)"archive.index.standard.limit", (boolean)false, v -> {
            indexStandardLimit = v;
        });
    }
}

