/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.sync.RetryUtil;
import kd.bos.archive.sync.spi.connection.ConnectionType;
import kd.bos.db.DBType;
import kd.bos.xdb.ParameterSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DBUtil.class);

    private DBUtil() {
    }

    public static Connection getConnection(ConnectionType connectionType, String jdbcUrl, String username, String password) {
        return DBUtil.getConnection(connectionType, jdbcUrl, username, password, String.valueOf(172800000));
    }

    public static Connection getConnection(final ConnectionType connectionType, final String jdbcUrl, final String username, final String password, final String socketTimeout) {
        try {
            return RetryUtil.executeWithRetry(new Callable<Connection>(){

                @Override
                public Connection call() throws Exception {
                    return DBUtil.connect(connectionType, jdbcUrl, username, password, socketTimeout);
                }
            }, 9, 1000L, true);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(String.format("getConnection failed. jdbcUrl:%s . please check your config.", jdbcUrl), e);
        }
    }

    public static Connection getConnectionWithoutRetry(ConnectionType connectionType, String jdbcUrl, String username, String password) {
        return DBUtil.getConnectionWithoutRetry(connectionType, jdbcUrl, username, password, String.valueOf(172800000));
    }

    public static Connection getConnectionWithoutRetry(ConnectionType connectionType, String jdbcUrl, String username, String password, String socketTimeout) {
        return DBUtil.connect(connectionType, jdbcUrl, username, password, socketTimeout);
    }

    private static synchronized Connection connect(ConnectionType connectionType, String url, String user, String pass) {
        return DBUtil.connect(connectionType, url, user, pass, String.valueOf(172800000));
    }

    private static synchronized Connection connect(ConnectionType connectionType, String url, String user, String pass, String socketTimeout) {
        Properties prop = new Properties();
        prop.put("user", user);
        prop.put("password", pass);
        return DBUtil.connect(connectionType, url, prop);
    }

    private static synchronized Connection connect(ConnectionType connectionType, String url, Properties prop) {
        try {
            Class.forName(connectionType.getDriverClassName());
            DriverManager.setLoginTimeout(15);
            return DriverManager.getConnection(url, prop);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }

    public static ResultSet query(Connection conn, String sql, int fetchSize) throws SQLException {
        return DBUtil.query(conn, sql, fetchSize, 172800);
    }

    public static ResultSet query(Connection conn, String sql, int fetchSize, int queryTimeout) throws SQLException {
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setFetchSize(fetchSize);
        stmt.setQueryTimeout(queryTimeout);
        return DBUtil.query(stmt, sql);
    }

    public static ResultSet query(Statement stmt, String sql) throws SQLException {
        return stmt.executeQuery(sql);
    }

    public static void execute(Statement stmt, String sql) throws SQLException {
        stmt.execute(sql);
    }

    public static void execute(Connection connection, String sql, Object ... params) {
        PreparedStatement preparedStatement = null;
        try {
            connection.setAutoCommit(true);
            preparedStatement = connection.prepareStatement(sql);
            ParameterSetter.fill((boolean)false, (PreparedStatement)preparedStatement, (Object[])params);
            preparedStatement.execute();
        }
        catch (Exception e) {
            try {
                String error = MessageFormat.format("DBUtil.execute error, sql:{0}, params:{1}", sql, params);
                LOG.error(error, (Throwable)e);
                throw ExceptionUtil.asRuntimeException(e);
            }
            catch (Throwable throwable) {
                DBUtil.closeDBResources(preparedStatement, null);
                throw throwable;
            }
        }
        DBUtil.closeDBResources(preparedStatement, null);
    }

    /*
     * Loose catch block
     */
    public static void executeBatch(Connection connection, String sql, List<Object[]> paramsList) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(sql);
            ParameterSetter.fillBatch((boolean)false, (PreparedStatement)preparedStatement, paramsList);
            preparedStatement.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            connection.rollback();
            DBUtil.executeBatchByOne(connection, sql, paramsList);
            DBUtil.closeDBResources(preparedStatement, null);
        }
        catch (Exception e2) {
            String error = MessageFormat.format("DBUtil.executeBatch error, sql:{0} ", sql);
            LOG.error(error, (Throwable)e2);
            throw ExceptionUtil.asRuntimeException(e2);
            {
                catch (Throwable throwable) {
                    DBUtil.closeDBResources(preparedStatement, null);
                    throw throwable;
                }
            }
        }
        DBUtil.closeDBResources(preparedStatement, null);
    }

    public static void executeBatchByOne(Connection connection, String sql, List<Object[]> paramsList) {
        PreparedStatement preparedStatement = null;
        try {
            connection.setAutoCommit(true);
            preparedStatement = connection.prepareStatement(sql);
            for (Object[] record : paramsList) {
                try {
                    ParameterSetter.fill((boolean)false, (PreparedStatement)preparedStatement, (Object[])record);
                    preparedStatement.execute();
                }
                catch (SQLException e) {
                    throw ExceptionUtil.asRuntimeException(e);
                }
                finally {
                    preparedStatement.clearParameters();
                }
            }
        }
        catch (Exception e) {
            try {
                String error = MessageFormat.format("DBUtil.executeBatchByOne error, sql:{0} ", sql);
                LOG.error(error, (Throwable)e);
                throw ExceptionUtil.asRuntimeException(e);
            }
            catch (Throwable throwable) {
                DBUtil.closeDBResources(preparedStatement, null);
                throw throwable;
            }
        }
        DBUtil.closeDBResources(preparedStatement, null);
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (null != rs) {
                Statement stmt = rs.getStatement();
                if (null != stmt) {
                    stmt.close();
                    stmt = null;
                }
                rs.close();
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void closeDBResources(ResultSet rs, Statement stmt, Connection conn) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeDBResources(Statement stmt, Connection conn) {
        DBUtil.closeDBResources(null, stmt, conn);
    }

    public static ResultSet query(Connection conn, String sql) throws SQLException {
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setQueryTimeout(172800);
        return DBUtil.query(conn, sql, null);
    }

    public static ResultSet query(Connection conn, String sql, Object ... params) throws SQLException {
        Statement stmt = null;
        if (params == null || params.length == 0) {
            stmt = conn.createStatement(1003, 1007);
            stmt.setQueryTimeout(172800);
        } else {
            stmt = conn.prepareStatement(sql, 1003, 1007);
            ParameterSetter.fill((boolean)false, (PreparedStatement)((PreparedStatement)stmt), (Object[])params);
            stmt.setQueryTimeout(172800);
        }
        return stmt.executeQuery(sql);
    }

    public static DBType getDBType(Connection con) throws SQLException {
        String dbType = con.getMetaData().getDatabaseProductName().toLowerCase();
        if (dbType.indexOf("postgresql") != -1) {
            return DBType.PostgreSQL;
        }
        if (dbType.indexOf("mysql") != -1 || dbType.indexOf("mariadb") != -1) {
            return DBType.MySQL;
        }
        if (dbType.indexOf("oracle") != -1) {
            return DBType.Oracle;
        }
        if (dbType.indexOf("sqlserver") != -1 || dbType.indexOf("microsoft") != -1) {
            return DBType.SQLServer;
        }
        if (dbType.indexOf("dm") != -1) {
            return DBType.DM;
        }
        if (dbType.indexOf("gs") != -1) {
            return DBType.GS;
        }
        if (dbType.indexOf("gs100") != -1 || dbType.indexOf("zenith") != -1) {
            return DBType.GS100;
        }
        return null;
    }
}

