/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.archive.sync.DestinationConfig;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.util.StringUtils;

public class DestinationConfigFactory {
    private static ConcurrentHashMap<String, DestinationConfig> destinationConfigMap = new ConcurrentHashMap();

    public static DestinationConfig getDestinationConfig(String region) {
        String tenantIdRegion = RequestContext.get().getTenantId() + "_" + region;
        return destinationConfigMap.computeIfAbsent(tenantIdRegion, k -> DestinationConfigFactory.loadDestinationConfig(region));
    }

    public static DestinationConfig loadDestinationConfig(String region) {
        String password;
        String key = RequestContext.get().getTenantId() + "_" + "archive.sync.destination" + "." + region;
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"DestinationConfigFactory_0", (String)"[ %s ] The synchronous configuration destination address is not configured.", (Object[])new Object[]{key}));
        }
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"DestinationConfigFactory_1", (String)"[ %s ] Synchronous configuration destination address parsing exception.", (Object[])new Object[]{key}), e);
        }
        DestinationConfig destinationConfig = new DestinationConfig();
        String jdbcUrl = prop.getProperty("jdbcUrl");
        if (StringUtils.isEmpty((String)jdbcUrl)) {
            throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"DestinationConfigFactory_2", (String)"[ %s ] The synchronous configuration jdbcUrl is empty.", (Object[])new Object[]{key}));
        }
        destinationConfig.setJdbcUrl(jdbcUrl);
        String username = prop.getProperty("username");
        if (username != null) {
            destinationConfig.setUsername(username);
        }
        if ((password = prop.getProperty("ppword")) != null) {
            destinationConfig.setPassword(password);
        }
        return destinationConfig;
    }
}

