/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.sync.service.taskgroup.pk.SyncPkForwardOrmReader;
import kd.bos.archive.sync.service.taskgroup.pk.SyncPkForwardPluginReader;
import kd.bos.archive.sync.service.taskgroup.pk.SyncPkForwardWriter;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.enums.State;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.archive.task.service.db.split.entity.PairPk;
import kd.bos.archive.task.service.db.split.entity.SplitInfo;
import kd.bos.archive.task.taskgroup.Reader;
import kd.bos.archive.task.taskgroup.TaskGroupExecutor;
import kd.bos.archive.task.taskgroup.communication.Communication;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.archive.ArchiveName;
import kd.bos.util.StringUtils;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.TableName;

public class SyncPkInsertService
extends TaskServiceAbst {
    private WriterConfiguration configuration;

    public SyncPkInsertService(ArchiveTaskEntity taskEntity, WriterConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.PKINSERT);
        this.configuration = configuration;
    }

    @Override
    protected void archiveInit() throws SQLException {
        super.archiveInit();
        boolean isExist = TableManager.get().existTable(this.configuration.getRoute(), ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkmTable(0L));
        if (!isExist) {
            TableManager.get().createTranMvTable(this.configuration.getRoute(), this.configuration.getMainTable(), true, 0L, ArchiveUtil.getPkTypeEnum(this.configuration.getEntitynumber()));
        }
    }

    @Override
    public boolean doArchive() throws Exception {
        SyncPkForwardWriter pkWriter;
        Reader pkReader;
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncPkInsertService doArchive begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        Object prePk = null;
        if (this.mp.isContinueSharding()) {
            prePk = this.mp.getToPk();
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_0", (String)"Continue data filtering, interrupt location pk:{0}", (Object[])new Object[]{prePk}));
        } else {
            String taskPrePk = this.taskEntity.getPrepk();
            PkTypeEnum pkTypeEnum = ArchiveUtil.getPkTypeEnum(this.configuration.getEntitynumber());
            prePk = StringUtils.isEmpty((String)taskPrePk) ? null : (pkTypeEnum == PkTypeEnum.pk_long ? Long.valueOf(Long.parseLong(taskPrePk.trim())) : taskPrePk.trim());
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_1", (String)"Start to data filter, first time execute...", (Object[])new Object[0]));
        }
        this.mp.store();
        if (this.configuration.getArchivePlugin() == null) {
            pkReader = new SyncPkForwardOrmReader(this.configuration, prePk);
            pkWriter = new SyncPkForwardWriter(this.configuration, this.mp);
        } else {
            SqlBuilder delSqlBuilder = new SqlBuilder();
            delSqlBuilder.append("/*dialect*/", new Object[0]);
            delSqlBuilder.append("/*XDB:NO_SHARDING*/", new Object[0]);
            delSqlBuilder.append("truncate table ", new Object[0]).append(ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkmTable((long)this.configuration.getConfigEntity().getSuffix()), new Object[0]);
            ArchiveUtil.wrapSqlBuilderExecute(this.configuration.getRoute(), delSqlBuilder);
            pkReader = new SyncPkForwardPluginReader(this.configuration);
            pkWriter = new SyncPkForwardWriter(this.configuration, this.mp);
        }
        Communication runnerCommunication = new Communication();
        TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, this.taskNodeEnum.getKey());
        pkGroupExecutor.doStart();
        if (runnerCommunication.getState() == State.FAILED) {
            StringWriter sw = new StringWriter();
            runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveTaskHandler SyncPkInsertService doArchive stateReturnFailed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), sw.toString());
            ArchiveUtil.logError(error, runnerCommunication.getThrowable());
            ArchiveLogPublish.get().publishLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
            throw ExceptionUtil.asRuntimeException(sw.toString(), runnerCommunication.getThrowable());
        }
        ArchiveName mainTN = ArchiveName.of((String)this.configuration.getMainTable());
        String mainMvTable = mainTN.getArchivePkmTable(0L);
        StringBuilder sql = new StringBuilder();
        if (this.configuration.isXdb()) {
            String pkTable = TableName.of((String)this.configuration.getMainTable()).getPKTable();
            sql.append("update ").append(mainMvTable).append(" t1 set findex = (select t2.findex from ").append(pkTable).append(" t2 where t1.fid = t2.fpk)");
            DB.execute((DBRoute)this.configuration.getRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), false, true));
        }
        List<Long> indexList = this.getPkIndexs(mainMvTable);
        ArrayList<SplitInfo> splitAllList = new ArrayList<SplitInfo>(10);
        for (Long index : indexList) {
            List<SplitInfo> splitList = this.split(mainMvTable, index);
            splitAllList.addAll(splitList);
        }
        if (splitAllList.size() > 0) {
            ArchiveSplitTaskRepository.get().deleteSplitTask(this.taskEntity.getId());
            ArchiveSplitTaskRepository.get().insertSplitTask(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), ArchiveTaskNodeEnum.PKINSERT, splitAllList);
        }
        if (null != this.mp.getToPk()) {
            ArchiveTaskRepository.get().updatePrepk(this.taskEntity.getId(), this.mp.getToPk().toString());
        }
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_3", (String)"Data filter complete", (Object[])new Object[0]));
        this.mp.setToPk(null);
        this.mp.store();
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncPkInsertService doArchive  end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        return false;
    }

    private List<Long> getPkIndexs(String mainMvTable) {
        StringBuilder pkQuerySql = new StringBuilder(256).append("SELECT DISTINCT(findex) FINDEX FROM ").append(mainMvTable);
        return (List)DB.query((DBRoute)this.configuration.getRoute(), (String)pkQuerySql.toString(), rs -> {
            ArrayList<Long> ret = new ArrayList<Long>(8);
            while (rs.next()) {
                ret.add(rs.getLong(1));
            }
            return ret;
        });
    }

    private List<SplitInfo> split(String mainMvTable, Long index) {
        StringBuilder sql = new StringBuilder("select count(*) from ").append(mainMvTable).append(" where findex =?");
        long pkCount = (Long)DB.query((DBRoute)this.configuration.getRoute(), (String)sql.toString(), (Object[])new Object[]{index}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        int splitPageSize = ArchiveConstant.SYNC_SPLIT_PAGE_SIZE;
        long pageSize = 0L;
        long lastPageSize = 0L;
        int count = 0;
        if (pkCount > (long)splitPageSize) {
            pageSize = splitPageSize;
            count = (int)(pkCount / pageSize) + (pkCount % pageSize > 0L ? 1 : 0);
        } else if (pkCount > 0L) {
            pageSize = (int)pkCount;
            count = 1;
        } else {
            count = 0;
        }
        ArrayList<SplitInfo> splitList = new ArrayList<SplitInfo>(count);
        if (count > 0) {
            lastPageSize = pkCount % pageSize > 0L ? pkCount % pageSize : pageSize;
            sql.setLength(0);
            sql.append("select top 1 ").append(" fid from ").append(mainMvTable).append(" where findex =?").append(" order by fid asc ");
            Object firstPk = DB.query((DBRoute)this.configuration.getRoute(), (String)sql.toString(), (Object[])new Object[]{index}, rs -> {
                if (rs.next()) {
                    return rs.getObject(1);
                }
                return 0L;
            });
            sql.setLength(0);
            sql.append("select top 1 ").append(" fid from ").append(mainMvTable).append(" where findex =?").append(" order by fid desc ");
            Object endPk = DB.query((DBRoute)this.configuration.getRoute(), (String)sql.toString(), (Object[])new Object[]{index}, rs -> {
                if (rs.next()) {
                    return rs.getObject(1);
                }
                return 0L;
            });
            for (int i = 0; i < count; ++i) {
                SplitInfo splitInfo = new SplitInfo();
                splitList.add(splitInfo);
                splitInfo.setIndex(index);
                splitInfo.setPageNum(i + 1);
                PairPk pairPk = new PairPk();
                splitInfo.setPairPk(pairPk);
            }
            Object lastPk = firstPk;
            for (int i = 0; i < count; ++i) {
                SplitInfo curInfo = (SplitInfo)splitList.get(i);
                if (i == 0) {
                    curInfo.getPairPk().setHeadPk(firstPk);
                }
                if (i == count - 1) {
                    curInfo.setPageSize(lastPageSize);
                    curInfo.getPairPk().setTailPk(endPk);
                    continue;
                }
                curInfo.setPageSize(pageSize);
                SplitInfo nextInfo = (SplitInfo)splitList.get(i + 1);
                sql.setLength(0);
                sql.append("select top 2,").append(pageSize - 1L).append(" fid from ").append(mainMvTable).append(" where findex = ? ").append(" and fid >= ? ").append(" order by fid asc ");
                lastPk = DB.query((DBRoute)this.configuration.getRoute(), (String)sql.toString(), (Object[])new Object[]{index, lastPk}, rs -> {
                    int size = 0;
                    Object temp = 0;
                    while (rs.next()) {
                        Object value = rs.getObject(1);
                        if (size == 0) {
                            curInfo.getPairPk().setTailPk(value);
                        } else {
                            nextInfo.getPairPk().setHeadPk(value);
                            temp = value;
                        }
                        ++size;
                    }
                    return temp;
                });
            }
        }
        return splitList;
    }
}

