/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.sync.service.split.SyncSplitCrossMoveService;
import kd.bos.archive.sync.service.split.SyncSplitPkInsertService;
import kd.bos.archive.sync.service.split.SyncSplitTempCleanService;
import kd.bos.archive.task.config.WriterConfiguration;

public class SyncSplitTaskContainer {
    private final ArchiveSplitTaskEntity splitTaskEntity;
    private final WriterConfiguration configuration;

    public SyncSplitTaskContainer(ArchiveSplitTaskEntity splitTaskEntity, WriterConfiguration configuration) {
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
    }

    public void start() {
        try {
            SyncSplitPkInsertService syncSplitPkInsertService = new SyncSplitPkInsertService(this.splitTaskEntity, this.configuration);
            SyncSplitCrossMoveService syncSplitCrossMoveService = new SyncSplitCrossMoveService(this.splitTaskEntity, this.configuration);
            SyncSplitTempCleanService syncSplitTempCleanService = new SyncSplitTempCleanService(this.splitTaskEntity, this.configuration);
            syncSplitPkInsertService.setNext(syncSplitCrossMoveService);
            syncSplitCrossMoveService.setNext(syncSplitTempCleanService);
            syncSplitPkInsertService.archive();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveTaskHandler SyncSplitTaskContainer error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), sw.toString());
            ArchiveUtil.logError(error, e);
            ArchiveSplitTaskEntity curTaskEntity = ArchiveSplitTaskRepository.get().loadSplitTask(this.splitTaskEntity.getId());
            if (ArchiveTaskStatusEnum.UNEXECUTED == curTaskEntity.getTaskstatus()) {
                ArchiveSplitTaskRepository.get().setNextSplitTaskstatus(this.splitTaskEntity.getId(), ArchiveTaskStatusEnum.UNEXECUTED, ArchiveTaskStatusEnum.FAILED);
            } else {
                ArchiveSplitTaskRepository.get().setNextSplitTaskstatus(this.splitTaskEntity.getId(), ArchiveTaskStatusEnum.EXECUTING, ArchiveTaskStatusEnum.FAILED);
            }
            ArchiveLogPublish.get().publishLog(this.configuration.getTaskEntity().getId(), this.splitTaskEntity.getEntitynumber(), error, "MOVINGHANDLER");
        }
    }
}

