/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.sync.DBUtil;
import kd.bos.archive.sync.DestinationConfig;
import kd.bos.archive.sync.spi.destination.Destination;
import kd.bos.archive.tablemanager.ArchiveLockCreateCall;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaFactory;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.util.DisCardUtil;
import kd.bos.util.JSONUtils;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class SyncStructureCheckService
extends TaskServiceAbst {
    private final DBRoute route;
    private WriterConfiguration configuration;
    private Destination destination;

    public SyncStructureCheckService(ArchiveTaskEntity taskEntity, WriterConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.TBSTRUCTCHK);
        this.configuration = configuration;
        this.route = this.configuration.getRoute();
        this.destination = configuration.getDestination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doArchive() throws Exception {
        DestinationConfig destinationConfig = this.configuration.getDestinationConfig();
        Connection connection = DBUtil.getConnection(this.configuration.getConnectionType(), destinationConfig.getJdbcUrl(), destinationConfig.getUsername(), destinationConfig.getPassword());
        try {
            for (ArchiveConfig archiveConfig : this.configuration.getConfigs()) {
                String oriTable = archiveConfig.getTable();
                boolean isExist = this.existTable(connection, oriTable);
                if (!isExist) {
                    this.createCrossTable(connection, oriTable);
                    continue;
                }
                this.checkCloumnSame(connection, oriTable);
            }
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"TbStructureCheckService_0", (String)"Structural Migration Complete", (Object[])new Object[0]));
            this.mp.setToPk(null);
            this.mp.store();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtil.closeDBResources(null, null, connection);
        }
    }

    private void checkCloumnSame(Connection connection, String oriTable) throws SQLException {
        List<Column> surplusColumn;
        List<Column> oriColumns = TableManager.get().getColumns(this.route, oriTable);
        List<Column> archiColumns = this.getColumns(connection, oriTable);
        List<Column> lackerColumn = TableManager.get().findLackedColumn(oriColumns, archiColumns);
        if (lackerColumn.size() > 0) {
            for (Column column : lackerColumn) {
                this.addColumn(connection, oriTable, column);
            }
        }
        if ((surplusColumn = TableManager.get().findSurplusColumn(oriColumns, archiColumns)).size() > 0 && log.isInfoEnabled()) {
            try {
                log.warn(MessageFormat.format("SyncStructureCheckService checkCloumnSame destination:{0},oriTable,{1},surplusColumn:{2}", this.configuration.getDestinationConfig().getJdbcUrl(), oriTable, JSONUtils.toString(surplusColumn)));
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
    }

    public boolean existTable(Connection connection, String tableName) throws SQLException {
        String existTableSql = this.configuration.getDestination().getExistTableSql(tableName);
        ResultSet resultSet = DBUtil.query(connection, existTableSql);
        return resultSet.next();
    }

    public void createCrossTable(Connection connection, String oriTable) throws SQLException {
        Callable<Object> call = () -> {
            this.__docreateCrossTableLike(connection, oriTable);
            return null;
        };
        ArchiveLockCreateCall.lockAndCall(oriTable, () -> {
            if (!this.existTable(connection, oriTable)) {
                try {
                    call.call();
                }
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    throw ExceptionUtil.wrap(e);
                }
            }
        });
    }

    private void __docreateCrossTableLike(Connection connection, String oriTable) throws SQLException {
        if (!this.existTable(connection, oriTable)) {
            String createTablePK;
            String createTableSQL;
            String snapTable = DB.getOriginalsnapTableNameIfShardingTable((String)oriTable);
            Imeta meta = MetaFactory.getMeta(this.route);
            List<Column> columnList = meta.queryColumns(this.route, snapTable);
            if (this.configuration.isSourceDestinationSame()) {
                createTableSQL = meta.createTableSql(oriTable, columnList);
                DBUtil.execute(connection, createTableSQL, null);
            } else {
                columnList.forEach(item -> meta.convertDialectToKsqlDataType((Column)item));
                createTableSQL = this.createTableSql(oriTable, columnList);
                DBUtil.execute(connection, createTableSQL, null);
            }
            PkInfo pkInfo = meta.queryPkInfo(this.route, snapTable);
            if (this.configuration.isSourceDestinationSame()) {
                createTablePK = meta.createPkIndexSql(oriTable, pkInfo, "", "");
                DBUtil.execute(connection, createTablePK, null);
            } else {
                createTablePK = this.destination.getCreatePkIndexSql(oriTable, pkInfo);
                DBUtil.execute(connection, createTablePK, null);
            }
            List<CreateIndexSqlInfo> createIndexSqlInfoList = meta.createIndexSql(this.route, oriTable, snapTable, pkInfo, "", "");
            if (this.configuration.isSourceDestinationSame()) {
                for (CreateIndexSqlInfo indexInfo : createIndexSqlInfoList) {
                    String createIndexSql = indexInfo.getCreateIndexSql();
                    DBUtil.execute(connection, createIndexSql, null);
                }
            }
        }
    }

    public String createTableSql(String table, List<Column> columnList) {
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.destination.getDialectColumnDesc(column));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    public void addColumn(Connection connection, String table, Column column) {
        StringBuilder addColumnSql = new StringBuilder(1024);
        if (this.configuration.isSourceDestinationSame()) {
            Imeta meta = MetaFactory.getMeta(this.route);
            addColumnSql.append("alter table ").append(table).append(" add ").append(meta.getColumnDesc(column, true));
        } else {
            Imeta meta = MetaFactory.getMeta(this.route);
            meta.convertDialectToKsqlDataType(column);
            addColumnSql.append("alter table ").append(table).append(" add ").append(this.destination.getDialectColumnDesc(column));
        }
        DBUtil.execute(connection, addColumnSql.toString(), null);
    }

    public List<Column> getColumns(Connection connection, String table) {
        try {
            String sql = this.destination.getQueryColumnsSql(table);
            ResultSet resultSet = DBUtil.query(connection, sql);
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            while (resultSet.next()) {
                Column column = new Column();
                int column_id = resultSet.getInt("column_id");
                String data_default = resultSet.getString("data_default");
                String column_name = resultSet.getString("column_name");
                String data_type = resultSet.getString("data_type");
                long data_length = this.parseLongNullAsZero(resultSet.getString("data_length"));
                int data_precision = this.parseIntNullAsZero(resultSet.getString("data_precision"));
                int data_scale = this.parseIntNullAsZero(resultSet.getString("data_scale"));
                column.setColumnId(column_id);
                column.setColumnName(column_name);
                column.setDataType(data_type);
                column.setDataLength(data_length);
                column.setDataPrecision(data_precision);
                column.setDataScale(data_scale);
                column.setDataDefault((Object)this.destination.decorateDataDefault(data_default));
                columnList.add(column);
            }
            return columnList;
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }

    private int parseIntNullAsZero(String s) {
        return s == null ? 0 : Integer.parseInt(s);
    }

    private long parseLongNullAsZero(String s) {
        return s == null ? 0L : Long.parseLong(s);
    }
}

