/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.split;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveSubTaskEntity;
import kd.bos.archive.enums.ArchiveSubTaskTypeEnum;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.SubTaskProgress;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.service.parallel.ArchiveThreadPool;
import kd.bos.archive.sync.service.split.work.SyncSplitMoveWork;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.service.SplitTaskServiceAbst;
import kd.bos.archive.task.service.db.split.move.work.SplitMoveWorkRunner;
import kd.bos.bundle.BosRes;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.util.Threads;

public class SyncSplitCrossMoveService
extends SplitTaskServiceAbst {
    protected WriterConfiguration configuration;

    public SyncSplitCrossMoveService(ArchiveSplitTaskEntity splitTaskEntity, WriterConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.CROSSMOVE);
        this.configuration = configuration;
    }

    @Override
    protected void archiveInit() throws SQLException {
        super.archiveInit();
        for (ArchiveConfig archiveConfig : this.configuration.getConfigs()) {
            if (ArchiveSubTaskRepository.get().checkExistsSubTask(this.splitTaskEntity.getId(), archiveConfig.getTable(), ArchiveSubTaskTypeEnum.CROSS)) continue;
            ArchiveSubTaskRepository.get().insertSubTask(this.splitTaskEntity.getId(), archiveConfig.getTable(), this.configuration.getEntitynumber(), ArchiveSubTaskTypeEnum.CROSS);
        }
    }

    @Override
    public boolean doArchive() throws Exception {
        ArchiveSubTaskTypeEnum subTaskTypeEnum = ArchiveSubTaskTypeEnum.CROSS;
        return this.doMove(subTaskTypeEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doMove(ArchiveSubTaskTypeEnum subTaskTypeEnum) throws Exception {
        long unclosed;
        block30: {
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitCrossMoveService doMove begin,entitynumber:{0}, taskId:{1}, tasknode:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), this.taskNodeEnum.getKey()));
            if (ArchiveServiceConfig.isEnableParallel()) {
                this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_0", (String)"Migrate Data in Parallel", (Object[])new Object[0]));
            } else {
                this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_1", (String)"Serial Migration of Data", (Object[])new Object[0]));
            }
            this.mp.store();
            List<ArchiveSubTaskEntity> subTaskEntities = ArchiveSubTaskRepository.get().loadUnexecutedSubTaskList(this.splitTaskEntity.getId(), subTaskTypeEnum);
            if (subTaskEntities.isEmpty()) {
                if (ArchiveSubTaskRepository.get().countSubTaskUnclosed(this.splitTaskEntity.getId(), subTaskTypeEnum) > 0L) {
                    throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_2", (String)"There are unfinished migration subtasks.", (Object[])new Object[0]));
                }
                ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitCrossMoveService doMove end,entitynumber:{0}, taskId:{1}, subTaskCount:{2}, tasknode:{3}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), subTaskEntities.size(), this.taskNodeEnum.getKey()));
            }
            boolean isPaused = false;
            if (ArchiveServiceConfig.isEnableParallel()) {
                try (ArchiveThreadPool threadPool = new ArchiveThreadPool();){
                    threadPool.setTable(this.configuration.getMainTable());
                    threadPool.setName("ARCHIVE-SplitParallelThread-");
                    threadPool.start();
                    ArrayList futureList = new ArrayList(subTaskEntities.size());
                    for (ArchiveSubTaskEntity subTask : subTaskEntities) {
                        SubTaskProgress sp = SubTaskProgress.of(subTask.getId(), this.splitTaskEntity.getEntitynumber(), subTask.getProgresssign(), this.mp);
                        sp.setProgressType(this.getProgressType());
                        Future future = threadPool.submit(Threads.wrapCallable((Callable)new SplitMoveWorkRunner(new SyncSplitMoveWork(this.splitTaskEntity, subTask, this.configuration, sp), subTask)));
                        futureList.add(future);
                    }
                    boolean isException = false;
                    String runtimeException = "";
                    for (Future future : futureList) {
                        try {
                            if (isException) {
                                future.cancel(true);
                                continue;
                            }
                            if (!isPaused) {
                                isPaused = (Boolean)future.get();
                                continue;
                            }
                            future.get();
                        }
                        catch (Throwable e) {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            String error = MessageFormat.format("ArchiveTaskHandler SyncSplitCrossMoveService doMove future.get error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), isException, sw.toString());
                            ArchiveUtil.logError(error, e);
                            ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, this.getProgressType());
                            if (isException) continue;
                            runtimeException = sw.toString();
                            isException = true;
                        }
                    }
                    if (isException) {
                        threadPool.shutdown();
                        while (!threadPool.isTerminated()) {
                            Thread.sleep(200L);
                        }
                        throw new RuntimeException(runtimeException);
                    }
                    break block30;
                }
                finally {
                    ThreadLocals.release();
                }
            }
            for (ArchiveSubTaskEntity subTask : subTaskEntities) {
                SubTaskProgress sp = SubTaskProgress.of(subTask.getId(), this.splitTaskEntity.getEntitynumber(), subTask.getProgresssign(), this.mp);
                sp.setProgressType(this.getProgressType());
                isPaused = new SyncSplitMoveWork(this.splitTaskEntity, subTask, this.configuration, sp).doWork();
                if (isPaused) break;
                sp.setExecSql(null);
                sp.store(false);
            }
        }
        if ((unclosed = ArchiveSubTaskRepository.get().countSubTaskUnclosed(this.splitTaskEntity.getId(), subTaskTypeEnum)) > 0L) {
            throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_2", (String)"There are unfinished migration subtasks.", (Object[])new Object[0]));
        }
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_3", (String)"{0} Migration Completed", (Object[])new Object[]{this.taskNodeEnum.getValue()}));
        this.mp.store();
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitCrossMoveService doMove end,entitynumber:{0}, taskId:{1}, tasknode:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), this.taskNodeEnum.getKey()));
        return false;
    }
}

