/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.split;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.sync.service.taskgroup.split.SyncPkSplitDbReader;
import kd.bos.archive.sync.service.taskgroup.split.SyncPkSplitWriter;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.enums.State;
import kd.bos.archive.task.service.SplitTaskServiceAbst;
import kd.bos.archive.task.taskgroup.TaskGroupExecutor;
import kd.bos.archive.task.taskgroup.communication.Communication;
import kd.bos.bundle.BosRes;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;

public class SyncSplitPkInsertService
extends SplitTaskServiceAbst {
    private WriterConfiguration configuration;

    public SyncSplitPkInsertService(ArchiveSplitTaskEntity splitTaskEntity, WriterConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.PKINSERT);
        this.configuration = configuration;
    }

    @Override
    protected void archiveInit() throws SQLException {
        super.archiveInit();
        for (ArchiveConfig archiveConfig : this.configuration.getSortKey()) {
            boolean isMain;
            boolean bl = isMain = archiveConfig == this.configuration.getMainArchiveConfig();
            boolean isExist = TableManager.get().existTable(this.configuration.getRoute(), ArchiveName.of((String)archiveConfig.getTable()).getArchivePkmTable((long)this.splitTaskEntity.getSeq()));
            if (isExist) continue;
            TableManager.get().createTranMvTable(this.configuration.getRoute(), archiveConfig.getTable(), isMain, this.splitTaskEntity.getSeq(), this.getPkTypeEnum());
        }
    }

    @Override
    public boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitPkInsertService doArchive begin,entitynumber:{0}, splitTaskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        Object prePk = null;
        if (this.mp.isContinueSharding()) {
            prePk = this.mp.getToPk();
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_0", (String)"Continue data filtering, interrupt location pk:{0}", (Object[])new Object[]{prePk}));
        } else {
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_1", (String)"Start to data filter, first time execute...", (Object[])new Object[0]));
        }
        this.mp.store();
        SyncPkSplitDbReader pkReader = new SyncPkSplitDbReader(this.splitTaskEntity, this.configuration, prePk);
        SyncPkSplitWriter pkWriter = new SyncPkSplitWriter(this.splitTaskEntity, this.configuration, this.mp);
        Communication runnerCommunication = new Communication();
        TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "SPLIT#" + this.taskNodeEnum.getKey());
        pkGroupExecutor.doStart();
        if (runnerCommunication.getState() == State.FAILED) {
            StringWriter sw = new StringWriter();
            runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveTaskHandler SyncSplitPkInsertService doArchive stateReturnFailed error,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), sw.toString());
            ArchiveUtil.logError(error, runnerCommunication.getThrowable());
            ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, this.getProgressType());
            throw ExceptionUtil.asRuntimeException(sw.toString(), runnerCommunication.getThrowable());
        }
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_3", (String)"Data filter complete", (Object[])new Object[0]));
        this.mp.setToPk(null);
        this.mp.store();
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitPkInsertService doArchive  end,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        return false;
    }
}

